package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.UserId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MatchedUser(
    userId: Optional[UserId] = Optional.Absent,
    userStatus: Optional[zio.aws.rekognition.model.UserStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.MatchedUser = {
    import MatchedUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.MatchedUser
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.MatchedUser.ReadOnly =
    zio.aws.rekognition.model.MatchedUser.wrap(buildAwsValue())
}
object MatchedUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.MatchedUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.MatchedUser =
      zio.aws.rekognition.model
        .MatchedUser(userId.map(value => value), userStatus.map(value => value))
    def userId: Optional[UserId]
    def userStatus: Optional[zio.aws.rekognition.model.UserStatus]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.UserStatus] =
      AwsError.unwrapOptionField("userStatus", userStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.MatchedUser
  ) extends zio.aws.rekognition.model.MatchedUser.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
    override val userStatus: Optional[zio.aws.rekognition.model.UserStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStatus())
        .map(value => zio.aws.rekognition.model.UserStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.MatchedUser
  ): zio.aws.rekognition.model.MatchedUser.ReadOnly = new Wrapper(impl)
}
