package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait LivenessSessionStatus {
  def unwrap
      : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus
}
object LivenessSessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus
  ): zio.aws.rekognition.model.LivenessSessionStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.LivenessSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus =
      software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.rekognition.model.LivenessSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus =
      software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.CREATED
  }
  case object IN_PROGRESS
      extends zio.aws.rekognition.model.LivenessSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus =
      software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.IN_PROGRESS
  }
  case object SUCCEEDED
      extends zio.aws.rekognition.model.LivenessSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus =
      software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.rekognition.model.LivenessSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus =
      software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.FAILED
  }
  case object EXPIRED extends zio.aws.rekognition.model.LivenessSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus =
      software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus.EXPIRED
  }
}
