package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{LivenessS3KeyPrefix, S3Bucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LivenessOutputConfig(
    s3Bucket: S3Bucket,
    s3KeyPrefix: Optional[LivenessS3KeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.LivenessOutputConfig = {
    import LivenessOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.LivenessOutputConfig
      .builder()
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3KeyPrefix.map(value =>
          LivenessS3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.s3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.LivenessOutputConfig.ReadOnly =
    zio.aws.rekognition.model.LivenessOutputConfig.wrap(buildAwsValue())
}
object LivenessOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.LivenessOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.LivenessOutputConfig =
      zio.aws.rekognition.model
        .LivenessOutputConfig(s3Bucket, s3KeyPrefix.map(value => value))
    def s3Bucket: S3Bucket
    def s3KeyPrefix: Optional[LivenessS3KeyPrefix]
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3KeyPrefix: ZIO[Any, AwsError, LivenessS3KeyPrefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.LivenessOutputConfig
  ) extends zio.aws.rekognition.model.LivenessOutputConfig.ReadOnly {
    override val s3Bucket: S3Bucket =
      zio.aws.rekognition.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3KeyPrefix: Optional[LivenessS3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3KeyPrefix())
        .map(value =>
          zio.aws.rekognition.model.primitives.LivenessS3KeyPrefix(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.LivenessOutputConfig
  ): zio.aws.rekognition.model.LivenessOutputConfig.ReadOnly = new Wrapper(impl)
}
