package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  PaginationToken,
  MaxUserResults,
  CollectionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUsersRequest(
    collectionId: CollectionId,
    maxResults: Optional[MaxUserResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListUsersRequest = {
    import ListUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListUsersRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxUserResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListUsersRequest.ReadOnly =
    zio.aws.rekognition.model.ListUsersRequest.wrap(buildAwsValue())
}
object ListUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListUsersRequest =
      zio.aws.rekognition.model.ListUsersRequest(
        collectionId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def collectionId: CollectionId
    def maxResults: Optional[MaxUserResults]
    def nextToken: Optional[PaginationToken]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getMaxResults: ZIO[Any, AwsError, MaxUserResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListUsersRequest
  ) extends zio.aws.rekognition.model.ListUsersRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val maxResults: Optional[MaxUserResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxUserResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListUsersRequest
  ): zio.aws.rekognition.model.ListUsersRequest.ReadOnly = new Wrapper(impl)
}
