package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  UserId,
  FaceId,
  CollectionId,
  PaginationToken,
  PageSize
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFacesRequest(
    collectionId: CollectionId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    userId: Optional[UserId] = Optional.Absent,
    faceIds: Optional[Iterable[FaceId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListFacesRequest = {
    import ListFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        faceIds.map(value =>
          value.map { item =>
            FaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.faceIds)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListFacesRequest.ReadOnly =
    zio.aws.rekognition.model.ListFacesRequest.wrap(buildAwsValue())
}
object ListFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListFacesRequest =
      zio.aws.rekognition.model.ListFacesRequest(
        collectionId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        userId.map(value => value),
        faceIds.map(value => value)
      )
    def collectionId: CollectionId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PageSize]
    def userId: Optional[UserId]
    def faceIds: Optional[List[FaceId]]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getFaceIds: ZIO[Any, AwsError, List[FaceId]] =
      AwsError.unwrapOptionField("faceIds", faceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesRequest
  ) extends zio.aws.rekognition.model.ListFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.PageSize(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
    override val faceIds: Optional[List[FaceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.faceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.FaceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesRequest
  ): zio.aws.rekognition.model.ListFacesRequest.ReadOnly = new Wrapper(impl)
}
