package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait LandmarkType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.LandmarkType
}
object LandmarkType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.LandmarkType
  ): zio.aws.rekognition.model.LandmarkType = value match {
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.EYE_LEFT =>
      val r = eyeLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.EYE_RIGHT =>
      val r = eyeRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.NOSE =>
      val r = nose
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_LEFT =>
      val r = mouthLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_RIGHT =>
      val r = mouthRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_BROW_LEFT =>
      val r = leftEyeBrowLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_BROW_RIGHT =>
      val r = leftEyeBrowRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_BROW_UP =>
      val r = leftEyeBrowUp
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_BROW_LEFT =>
      val r = rightEyeBrowLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_BROW_RIGHT =>
      val r = rightEyeBrowRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_BROW_UP =>
      val r = rightEyeBrowUp
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_LEFT =>
      val r = leftEyeLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_RIGHT =>
      val r = leftEyeRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_UP =>
      val r = leftEyeUp
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_DOWN =>
      val r = leftEyeDown
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_LEFT =>
      val r = rightEyeLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_RIGHT =>
      val r = rightEyeRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_UP =>
      val r = rightEyeUp
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_DOWN =>
      val r = rightEyeDown
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.NOSE_LEFT =>
      val r = noseLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.NOSE_RIGHT =>
      val r = noseRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_UP =>
      val r = mouthUp
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_DOWN =>
      val r = mouthDown
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_PUPIL =>
      val r = leftPupil
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_PUPIL =>
      val r = rightPupil
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.UPPER_JAWLINE_LEFT =>
      val r = upperJawlineLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.MID_JAWLINE_LEFT =>
      val r = midJawlineLeft
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.CHIN_BOTTOM =>
      val r = chinBottom
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.MID_JAWLINE_RIGHT =>
      val r = midJawlineRight
      r
    case software.amazon.awssdk.services.rekognition.model.LandmarkType.UPPER_JAWLINE_RIGHT =>
      val r = upperJawlineRight
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.UNKNOWN_TO_SDK_VERSION
  }
  case object eyeLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.EYE_LEFT
  }
  case object eyeRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.EYE_RIGHT
  }
  case object nose extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.NOSE
  }
  case object mouthLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_LEFT
  }
  case object mouthRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_RIGHT
  }
  case object leftEyeBrowLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_BROW_LEFT
  }
  case object leftEyeBrowRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_BROW_RIGHT
  }
  case object leftEyeBrowUp extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_BROW_UP
  }
  case object rightEyeBrowLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_BROW_LEFT
  }
  case object rightEyeBrowRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_BROW_RIGHT
  }
  case object rightEyeBrowUp extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_BROW_UP
  }
  case object leftEyeLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_LEFT
  }
  case object leftEyeRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_RIGHT
  }
  case object leftEyeUp extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_UP
  }
  case object leftEyeDown extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_EYE_DOWN
  }
  case object rightEyeLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_LEFT
  }
  case object rightEyeRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_RIGHT
  }
  case object rightEyeUp extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_UP
  }
  case object rightEyeDown extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_EYE_DOWN
  }
  case object noseLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.NOSE_LEFT
  }
  case object noseRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.NOSE_RIGHT
  }
  case object mouthUp extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_UP
  }
  case object mouthDown extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.MOUTH_DOWN
  }
  case object leftPupil extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.LEFT_PUPIL
  }
  case object rightPupil extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.RIGHT_PUPIL
  }
  case object upperJawlineLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.UPPER_JAWLINE_LEFT
  }
  case object midJawlineLeft extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.MID_JAWLINE_LEFT
  }
  case object chinBottom extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.CHIN_BOTTOM
  }
  case object midJawlineRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.MID_JAWLINE_RIGHT
  }
  case object upperJawlineRight extends zio.aws.rekognition.model.LandmarkType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LandmarkType =
      software.amazon.awssdk.services.rekognition.model.LandmarkType.UPPER_JAWLINE_RIGHT
  }
}
