package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  JobId,
  PaginationToken,
  StatusMessage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTextDetectionResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    videoMetadata: Optional[zio.aws.rekognition.model.VideoMetadata] =
      Optional.Absent,
    textDetections: Optional[
      Iterable[zio.aws.rekognition.model.TextDetectionResult]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    textModelVersion: Optional[String] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    video: Optional[zio.aws.rekognition.model.Video] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse = {
    import GetTextDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        textDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textDetections)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(textModelVersion.map(value => value: java.lang.String))(
        _.textModelVersion
      )
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetTextDetectionResponse.wrap(buildAwsValue())
}
object GetTextDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetTextDetectionResponse =
      zio.aws.rekognition.model.GetTextDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        textDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        textModelVersion.map(value => value),
        jobId.map(value => value),
        video.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def textDetections
        : Optional[List[zio.aws.rekognition.model.TextDetectionResult.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def textModelVersion: Optional[String]
    def jobId: Optional[JobId]
    def video: Optional[zio.aws.rekognition.model.Video.ReadOnly]
    def jobTag: Optional[JobTag]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getTextDetections: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.TextDetectionResult.ReadOnly
    ]] = AwsError.unwrapOptionField("textDetections", textDetections)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("textModelVersion", textModelVersion)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getVideo: ZIO[Any, AwsError, zio.aws.rekognition.model.Video.ReadOnly] =
      AwsError.unwrapOptionField("video", video)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
  ) extends zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val textDetections: Optional[
      List[zio.aws.rekognition.model.TextDetectionResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.textDetections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.TextDetectionResult.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val textModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.textModelVersion())
      .map(value => value: String)
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
    override val video: Optional[zio.aws.rekognition.model.Video.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value => zio.aws.rekognition.model.Video.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse
  ): zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
