package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  JobId,
  PaginationToken,
  StatusMessage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSegmentDetectionResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    videoMetadata: Optional[Iterable[zio.aws.rekognition.model.VideoMetadata]] =
      Optional.Absent,
    audioMetadata: Optional[Iterable[zio.aws.rekognition.model.AudioMetadata]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    segments: Optional[Iterable[zio.aws.rekognition.model.SegmentDetection]] =
      Optional.Absent,
    selectedSegmentTypes: Optional[
      Iterable[zio.aws.rekognition.model.SegmentTypeInfo]
    ] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    video: Optional[zio.aws.rekognition.model.Video] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse = {
    import GetSegmentDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        videoMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.videoMetadata)
      .optionallyWith(
        audioMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.audioMetadata)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        segments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segments)
      .optionallyWith(
        selectedSegmentTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectedSegmentTypes)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetSegmentDetectionResponse.wrap(buildAwsValue())
}
object GetSegmentDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetSegmentDetectionResponse =
      zio.aws.rekognition.model.GetSegmentDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        audioMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        segments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selectedSegmentTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobId.map(value => value),
        video.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def videoMetadata
        : Optional[List[zio.aws.rekognition.model.VideoMetadata.ReadOnly]]
    def audioMetadata
        : Optional[List[zio.aws.rekognition.model.AudioMetadata.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def segments
        : Optional[List[zio.aws.rekognition.model.SegmentDetection.ReadOnly]]
    def selectedSegmentTypes
        : Optional[List[zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly]]
    def jobId: Optional[JobId]
    def video: Optional[zio.aws.rekognition.model.Video.ReadOnly]
    def jobTag: Optional[JobTag]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.VideoMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getAudioMetadata: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.AudioMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("audioMetadata", audioMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSegments: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.SegmentDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("segments", segments)
    def getSelectedSegmentTypes: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("selectedSegmentTypes", selectedSegmentTypes)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getVideo: ZIO[Any, AwsError, zio.aws.rekognition.model.Video.ReadOnly] =
      AwsError.unwrapOptionField("video", video)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
  ) extends zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Optional[List[zio.aws.rekognition.model.VideoMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.VideoMetadata.wrap(item)
          }.toList
        )
    override val audioMetadata
        : Optional[List[zio.aws.rekognition.model.AudioMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.AudioMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val segments
        : Optional[List[zio.aws.rekognition.model.SegmentDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.SegmentDetection.wrap(item)
          }.toList
        )
    override val selectedSegmentTypes
        : Optional[List[zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectedSegmentTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.SegmentTypeInfo.wrap(item)
          }.toList
        )
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
    override val video: Optional[zio.aws.rekognition.model.Video.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value => zio.aws.rekognition.model.Video.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
  ): zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
