package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  JobId,
  PaginationToken,
  StatusMessage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLabelDetectionResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    videoMetadata: Optional[zio.aws.rekognition.model.VideoMetadata] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    labels: Optional[Iterable[zio.aws.rekognition.model.LabelDetection]] =
      Optional.Absent,
    labelModelVersion: Optional[String] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    video: Optional[zio.aws.rekognition.model.Video] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent,
    getRequestMetadata: Optional[
      zio.aws.rekognition.model.GetLabelDetectionRequestMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse = {
    import GetLabelDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(labelModelVersion.map(value => value: java.lang.String))(
        _.labelModelVersion
      )
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(getRequestMetadata.map(value => value.buildAwsValue()))(
        _.getRequestMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetLabelDetectionResponse.wrap(buildAwsValue())
}
object GetLabelDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetLabelDetectionResponse =
      zio.aws.rekognition.model.GetLabelDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labelModelVersion.map(value => value),
        jobId.map(value => value),
        video.map(value => value.asEditable),
        jobTag.map(value => value),
        getRequestMetadata.map(value => value.asEditable)
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def labels
        : Optional[List[zio.aws.rekognition.model.LabelDetection.ReadOnly]]
    def labelModelVersion: Optional[String]
    def jobId: Optional[JobId]
    def video: Optional[zio.aws.rekognition.model.Video.ReadOnly]
    def jobTag: Optional[JobTag]
    def getRequestMetadata: Optional[
      zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.ReadOnly
    ]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLabels: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.LabelDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("labels", labels)
    def getLabelModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("labelModelVersion", labelModelVersion)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getVideo: ZIO[Any, AwsError, zio.aws.rekognition.model.Video.ReadOnly] =
      AwsError.unwrapOptionField("video", video)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getGetRequestMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("getRequestMetadata", getRequestMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
  ) extends zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val labels
        : Optional[List[zio.aws.rekognition.model.LabelDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.LabelDetection.wrap(item)
          }.toList
        )
    override val labelModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.labelModelVersion())
      .map(value => value: String)
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
    override val video: Optional[zio.aws.rekognition.model.Video.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value => zio.aws.rekognition.model.Video.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
    override val getRequestMetadata: Optional[
      zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getRequestMetadata())
      .map(value =>
        zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse
  ): zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
