package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  JobId,
  PaginationToken,
  StatusMessage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFaceSearchResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    videoMetadata: Optional[zio.aws.rekognition.model.VideoMetadata] =
      Optional.Absent,
    persons: Optional[Iterable[zio.aws.rekognition.model.PersonMatch]] =
      Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    video: Optional[zio.aws.rekognition.model.Video] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse = {
    import GetFaceSearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        persons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.persons)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly =
    zio.aws.rekognition.model.GetFaceSearchResponse.wrap(buildAwsValue())
}
object GetFaceSearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetFaceSearchResponse =
      zio.aws.rekognition.model.GetFaceSearchResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        nextToken.map(value => value),
        videoMetadata.map(value => value.asEditable),
        persons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobId.map(value => value),
        video.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def nextToken: Optional[PaginationToken]
    def videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def persons: Optional[List[zio.aws.rekognition.model.PersonMatch.ReadOnly]]
    def jobId: Optional[JobId]
    def video: Optional[zio.aws.rekognition.model.Video.ReadOnly]
    def jobTag: Optional[JobTag]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getPersons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.PersonMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("persons", persons)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getVideo: ZIO[Any, AwsError, zio.aws.rekognition.model.Video.ReadOnly] =
      AwsError.unwrapOptionField("video", video)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
  ) extends zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val persons
        : Optional[List[zio.aws.rekognition.model.PersonMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.persons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.PersonMatch.wrap(item)
          }.toList
        )
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
    override val video: Optional[zio.aws.rekognition.model.Video.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value => zio.aws.rekognition.model.Video.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse
  ): zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly = new Wrapper(
    impl
  )
}
