package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FaceDetail(
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    ageRange: Optional[zio.aws.rekognition.model.AgeRange] = Optional.Absent,
    smile: Optional[zio.aws.rekognition.model.Smile] = Optional.Absent,
    eyeglasses: Optional[zio.aws.rekognition.model.Eyeglasses] =
      Optional.Absent,
    sunglasses: Optional[zio.aws.rekognition.model.Sunglasses] =
      Optional.Absent,
    gender: Optional[zio.aws.rekognition.model.Gender] = Optional.Absent,
    beard: Optional[zio.aws.rekognition.model.Beard] = Optional.Absent,
    mustache: Optional[zio.aws.rekognition.model.Mustache] = Optional.Absent,
    eyesOpen: Optional[zio.aws.rekognition.model.EyeOpen] = Optional.Absent,
    mouthOpen: Optional[zio.aws.rekognition.model.MouthOpen] = Optional.Absent,
    emotions: Optional[Iterable[zio.aws.rekognition.model.Emotion]] =
      Optional.Absent,
    landmarks: Optional[Iterable[zio.aws.rekognition.model.Landmark]] =
      Optional.Absent,
    pose: Optional[zio.aws.rekognition.model.Pose] = Optional.Absent,
    quality: Optional[zio.aws.rekognition.model.ImageQuality] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    faceOccluded: Optional[zio.aws.rekognition.model.FaceOccluded] =
      Optional.Absent,
    eyeDirection: Optional[zio.aws.rekognition.model.EyeDirection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.FaceDetail = {
    import FaceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.FaceDetail
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(ageRange.map(value => value.buildAwsValue()))(_.ageRange)
      .optionallyWith(smile.map(value => value.buildAwsValue()))(_.smile)
      .optionallyWith(eyeglasses.map(value => value.buildAwsValue()))(
        _.eyeglasses
      )
      .optionallyWith(sunglasses.map(value => value.buildAwsValue()))(
        _.sunglasses
      )
      .optionallyWith(gender.map(value => value.buildAwsValue()))(_.gender)
      .optionallyWith(beard.map(value => value.buildAwsValue()))(_.beard)
      .optionallyWith(mustache.map(value => value.buildAwsValue()))(_.mustache)
      .optionallyWith(eyesOpen.map(value => value.buildAwsValue()))(_.eyesOpen)
      .optionallyWith(mouthOpen.map(value => value.buildAwsValue()))(
        _.mouthOpen
      )
      .optionallyWith(
        emotions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emotions)
      .optionallyWith(
        landmarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.landmarks)
      .optionallyWith(pose.map(value => value.buildAwsValue()))(_.pose)
      .optionallyWith(quality.map(value => value.buildAwsValue()))(_.quality)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(faceOccluded.map(value => value.buildAwsValue()))(
        _.faceOccluded
      )
      .optionallyWith(eyeDirection.map(value => value.buildAwsValue()))(
        _.eyeDirection
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.FaceDetail.ReadOnly =
    zio.aws.rekognition.model.FaceDetail.wrap(buildAwsValue())
}
object FaceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.FaceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.FaceDetail =
      zio.aws.rekognition.model.FaceDetail(
        boundingBox.map(value => value.asEditable),
        ageRange.map(value => value.asEditable),
        smile.map(value => value.asEditable),
        eyeglasses.map(value => value.asEditable),
        sunglasses.map(value => value.asEditable),
        gender.map(value => value.asEditable),
        beard.map(value => value.asEditable),
        mustache.map(value => value.asEditable),
        eyesOpen.map(value => value.asEditable),
        mouthOpen.map(value => value.asEditable),
        emotions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        landmarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pose.map(value => value.asEditable),
        quality.map(value => value.asEditable),
        confidence.map(value => value),
        faceOccluded.map(value => value.asEditable),
        eyeDirection.map(value => value.asEditable)
      )
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def ageRange: Optional[zio.aws.rekognition.model.AgeRange.ReadOnly]
    def smile: Optional[zio.aws.rekognition.model.Smile.ReadOnly]
    def eyeglasses: Optional[zio.aws.rekognition.model.Eyeglasses.ReadOnly]
    def sunglasses: Optional[zio.aws.rekognition.model.Sunglasses.ReadOnly]
    def gender: Optional[zio.aws.rekognition.model.Gender.ReadOnly]
    def beard: Optional[zio.aws.rekognition.model.Beard.ReadOnly]
    def mustache: Optional[zio.aws.rekognition.model.Mustache.ReadOnly]
    def eyesOpen: Optional[zio.aws.rekognition.model.EyeOpen.ReadOnly]
    def mouthOpen: Optional[zio.aws.rekognition.model.MouthOpen.ReadOnly]
    def emotions: Optional[List[zio.aws.rekognition.model.Emotion.ReadOnly]]
    def landmarks: Optional[List[zio.aws.rekognition.model.Landmark.ReadOnly]]
    def pose: Optional[zio.aws.rekognition.model.Pose.ReadOnly]
    def quality: Optional[zio.aws.rekognition.model.ImageQuality.ReadOnly]
    def confidence: Optional[Percent]
    def faceOccluded: Optional[zio.aws.rekognition.model.FaceOccluded.ReadOnly]
    def eyeDirection: Optional[zio.aws.rekognition.model.EyeDirection.ReadOnly]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getAgeRange
        : ZIO[Any, AwsError, zio.aws.rekognition.model.AgeRange.ReadOnly] =
      AwsError.unwrapOptionField("ageRange", ageRange)
    def getSmile: ZIO[Any, AwsError, zio.aws.rekognition.model.Smile.ReadOnly] =
      AwsError.unwrapOptionField("smile", smile)
    def getEyeglasses
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Eyeglasses.ReadOnly] =
      AwsError.unwrapOptionField("eyeglasses", eyeglasses)
    def getSunglasses
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Sunglasses.ReadOnly] =
      AwsError.unwrapOptionField("sunglasses", sunglasses)
    def getGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Gender.ReadOnly] =
      AwsError.unwrapOptionField("gender", gender)
    def getBeard: ZIO[Any, AwsError, zio.aws.rekognition.model.Beard.ReadOnly] =
      AwsError.unwrapOptionField("beard", beard)
    def getMustache
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Mustache.ReadOnly] =
      AwsError.unwrapOptionField("mustache", mustache)
    def getEyesOpen
        : ZIO[Any, AwsError, zio.aws.rekognition.model.EyeOpen.ReadOnly] =
      AwsError.unwrapOptionField("eyesOpen", eyesOpen)
    def getMouthOpen
        : ZIO[Any, AwsError, zio.aws.rekognition.model.MouthOpen.ReadOnly] =
      AwsError.unwrapOptionField("mouthOpen", mouthOpen)
    def getEmotions
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Emotion.ReadOnly]] =
      AwsError.unwrapOptionField("emotions", emotions)
    def getLandmarks: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Landmark.ReadOnly
    ]] = AwsError.unwrapOptionField("landmarks", landmarks)
    def getPose: ZIO[Any, AwsError, zio.aws.rekognition.model.Pose.ReadOnly] =
      AwsError.unwrapOptionField("pose", pose)
    def getQuality
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ImageQuality.ReadOnly] =
      AwsError.unwrapOptionField("quality", quality)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getFaceOccluded
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceOccluded.ReadOnly] =
      AwsError.unwrapOptionField("faceOccluded", faceOccluded)
    def getEyeDirection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.EyeDirection.ReadOnly] =
      AwsError.unwrapOptionField("eyeDirection", eyeDirection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.FaceDetail
  ) extends zio.aws.rekognition.model.FaceDetail.ReadOnly {
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val ageRange
        : Optional[zio.aws.rekognition.model.AgeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ageRange())
        .map(value => zio.aws.rekognition.model.AgeRange.wrap(value))
    override val smile: Optional[zio.aws.rekognition.model.Smile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smile())
        .map(value => zio.aws.rekognition.model.Smile.wrap(value))
    override val eyeglasses
        : Optional[zio.aws.rekognition.model.Eyeglasses.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eyeglasses())
        .map(value => zio.aws.rekognition.model.Eyeglasses.wrap(value))
    override val sunglasses
        : Optional[zio.aws.rekognition.model.Sunglasses.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sunglasses())
        .map(value => zio.aws.rekognition.model.Sunglasses.wrap(value))
    override val gender: Optional[zio.aws.rekognition.model.Gender.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gender())
        .map(value => zio.aws.rekognition.model.Gender.wrap(value))
    override val beard: Optional[zio.aws.rekognition.model.Beard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.beard())
        .map(value => zio.aws.rekognition.model.Beard.wrap(value))
    override val mustache
        : Optional[zio.aws.rekognition.model.Mustache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mustache())
        .map(value => zio.aws.rekognition.model.Mustache.wrap(value))
    override val eyesOpen
        : Optional[zio.aws.rekognition.model.EyeOpen.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eyesOpen())
        .map(value => zio.aws.rekognition.model.EyeOpen.wrap(value))
    override val mouthOpen
        : Optional[zio.aws.rekognition.model.MouthOpen.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mouthOpen())
        .map(value => zio.aws.rekognition.model.MouthOpen.wrap(value))
    override val emotions
        : Optional[List[zio.aws.rekognition.model.Emotion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emotions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Emotion.wrap(item)
          }.toList
        )
    override val landmarks
        : Optional[List[zio.aws.rekognition.model.Landmark.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.landmarks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Landmark.wrap(item)
          }.toList
        )
    override val pose: Optional[zio.aws.rekognition.model.Pose.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pose())
        .map(value => zio.aws.rekognition.model.Pose.wrap(value))
    override val quality
        : Optional[zio.aws.rekognition.model.ImageQuality.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quality())
        .map(value => zio.aws.rekognition.model.ImageQuality.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val faceOccluded
        : Optional[zio.aws.rekognition.model.FaceOccluded.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceOccluded())
        .map(value => zio.aws.rekognition.model.FaceOccluded.wrap(value))
    override val eyeDirection
        : Optional[zio.aws.rekognition.model.EyeDirection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eyeDirection())
        .map(value => zio.aws.rekognition.model.EyeDirection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.FaceDetail
  ): zio.aws.rekognition.model.FaceDetail.ReadOnly = new Wrapper(impl)
}
