package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociatedFace(faceId: Optional[FaceId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DisassociatedFace = {
    import DisassociatedFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DisassociatedFace
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DisassociatedFace.ReadOnly =
    zio.aws.rekognition.model.DisassociatedFace.wrap(buildAwsValue())
}
object DisassociatedFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DisassociatedFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DisassociatedFace =
      zio.aws.rekognition.model.DisassociatedFace(faceId.map(value => value))
    def faceId: Optional[FaceId]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DisassociatedFace
  ) extends zio.aws.rekognition.model.DisassociatedFace.ReadOnly {
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DisassociatedFace
  ): zio.aws.rekognition.model.DisassociatedFace.ReadOnly = new Wrapper(impl)
}
