package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateFacesResponse(
    disassociatedFaces: Optional[
      Iterable[zio.aws.rekognition.model.DisassociatedFace]
    ] = Optional.Absent,
    unsuccessfulFaceDisassociations: Optional[
      Iterable[zio.aws.rekognition.model.UnsuccessfulFaceDisassociation]
    ] = Optional.Absent,
    userStatus: Optional[zio.aws.rekognition.model.UserStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse = {
    import DisassociateFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse
      .builder()
      .optionallyWith(
        disassociatedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disassociatedFaces)
      .optionallyWith(
        unsuccessfulFaceDisassociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfulFaceDisassociations)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DisassociateFacesResponse.ReadOnly =
    zio.aws.rekognition.model.DisassociateFacesResponse.wrap(buildAwsValue())
}
object DisassociateFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DisassociateFacesResponse =
      zio.aws.rekognition.model.DisassociateFacesResponse(
        disassociatedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessfulFaceDisassociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userStatus.map(value => value)
      )
    def disassociatedFaces
        : Optional[List[zio.aws.rekognition.model.DisassociatedFace.ReadOnly]]
    def unsuccessfulFaceDisassociations: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceDisassociation.ReadOnly]
    ]
    def userStatus: Optional[zio.aws.rekognition.model.UserStatus]
    def getDisassociatedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.DisassociatedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("disassociatedFaces", disassociatedFaces)
    def getUnsuccessfulFaceDisassociations: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsuccessfulFaceDisassociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfulFaceDisassociations",
      unsuccessfulFaceDisassociations
    )
    def getUserStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.UserStatus] =
      AwsError.unwrapOptionField("userStatus", userStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse
  ) extends zio.aws.rekognition.model.DisassociateFacesResponse.ReadOnly {
    override val disassociatedFaces
        : Optional[List[zio.aws.rekognition.model.DisassociatedFace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociatedFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.DisassociatedFace.wrap(item)
          }.toList
        )
    override val unsuccessfulFaceDisassociations: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceDisassociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unsuccessfulFaceDisassociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.UnsuccessfulFaceDisassociation.wrap(item)
        }.toList
      )
    override val userStatus: Optional[zio.aws.rekognition.model.UserStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStatus())
        .map(value => zio.aws.rekognition.model.UserStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse
  ): zio.aws.rekognition.model.DisassociateFacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
