package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  FaceId,
  ClientRequestToken,
  UserId,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateFacesRequest(
    collectionId: CollectionId,
    userId: UserId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    faceIds: Iterable[FaceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest = {
    import DisassociateFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .faceIds(faceIds.map { item =>
        FaceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DisassociateFacesRequest.ReadOnly =
    zio.aws.rekognition.model.DisassociateFacesRequest.wrap(buildAwsValue())
}
object DisassociateFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DisassociateFacesRequest =
      zio.aws.rekognition.model.DisassociateFacesRequest(
        collectionId,
        userId,
        clientRequestToken.map(value => value),
        faceIds
      )
    def collectionId: CollectionId
    def userId: UserId
    def clientRequestToken: Optional[ClientRequestToken]
    def faceIds: List[FaceId]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFaceIds: ZIO[Any, Nothing, List[FaceId]] = ZIO.succeed(faceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest
  ) extends zio.aws.rekognition.model.DisassociateFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val userId: UserId =
      zio.aws.rekognition.model.primitives.UserId(impl.userId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
    override val faceIds: List[FaceId] = impl
      .faceIds()
      .asScala
      .map { item =>
        zio.aws.rekognition.model.primitives.FaceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest
  ): zio.aws.rekognition.model.DisassociateFacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
