package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectTextRequest(
    image: zio.aws.rekognition.model.Image,
    filters: Optional[zio.aws.rekognition.model.DetectTextFilters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectTextRequest = {
    import DetectTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectTextRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectTextRequest.ReadOnly =
    zio.aws.rekognition.model.DetectTextRequest.wrap(buildAwsValue())
}
object DetectTextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectTextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectTextRequest =
      zio.aws.rekognition.model.DetectTextRequest(
        image.asEditable,
        filters.map(value => value.asEditable)
      )
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def filters: Optional[zio.aws.rekognition.model.DetectTextFilters.ReadOnly]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectTextFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextRequest
  ) extends zio.aws.rekognition.model.DetectTextRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val filters
        : Optional[zio.aws.rekognition.model.DetectTextFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.rekognition.model.DetectTextFilters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextRequest
  ): zio.aws.rekognition.model.DetectTextRequest.ReadOnly = new Wrapper(impl)
}
