package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectProtectiveEquipmentRequest(
    image: zio.aws.rekognition.model.Image,
    summarizationAttributes: Optional[
      zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest = {
    import DetectProtectiveEquipmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(
        summarizationAttributes.map(value => value.buildAwsValue())
      )(_.summarizationAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectProtectiveEquipmentRequest.ReadOnly =
    zio.aws.rekognition.model.DetectProtectiveEquipmentRequest
      .wrap(buildAwsValue())
}
object DetectProtectiveEquipmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectProtectiveEquipmentRequest =
      zio.aws.rekognition.model.DetectProtectiveEquipmentRequest(
        image.asEditable,
        summarizationAttributes.map(value => value.asEditable)
      )
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def summarizationAttributes: Optional[
      zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes.ReadOnly
    ]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getSummarizationAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "summarizationAttributes",
      summarizationAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest
  ) extends zio.aws.rekognition.model.DetectProtectiveEquipmentRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val summarizationAttributes: Optional[
      zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summarizationAttributes())
      .map(value =>
        zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest
  ): zio.aws.rekognition.model.DetectProtectiveEquipmentRequest.ReadOnly =
    new Wrapper(impl)
}
