package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.DetectLabelsMaxDominantColors
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DetectLabelsImagePropertiesSettings(
    maxDominantColors: Optional[DetectLabelsMaxDominantColors] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsImagePropertiesSettings = {
    import DetectLabelsImagePropertiesSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImagePropertiesSettings
      .builder()
      .optionallyWith(
        maxDominantColors.map(value =>
          DetectLabelsMaxDominantColors.unwrap(value): Integer
        )
      )(_.maxDominantColors)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings
      .wrap(buildAwsValue())
}
object DetectLabelsImagePropertiesSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImagePropertiesSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings =
      zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings(
        maxDominantColors.map(value => value)
      )
    def maxDominantColors: Optional[DetectLabelsMaxDominantColors]
    def getMaxDominantColors
        : ZIO[Any, AwsError, DetectLabelsMaxDominantColors] =
      AwsError.unwrapOptionField("maxDominantColors", maxDominantColors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImagePropertiesSettings
  ) extends zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings.ReadOnly {
    override val maxDominantColors: Optional[DetectLabelsMaxDominantColors] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDominantColors())
        .map(value =>
          zio.aws.rekognition.model.primitives
            .DetectLabelsMaxDominantColors(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImagePropertiesSettings
  ): zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings.ReadOnly =
    new Wrapper(impl)
}
