package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectLabelsImageProperties(
    quality: Optional[zio.aws.rekognition.model.DetectLabelsImageQuality] =
      Optional.Absent,
    dominantColors: Optional[
      Iterable[zio.aws.rekognition.model.DominantColor]
    ] = Optional.Absent,
    foreground: Optional[
      zio.aws.rekognition.model.DetectLabelsImageForeground
    ] = Optional.Absent,
    background: Optional[
      zio.aws.rekognition.model.DetectLabelsImageBackground
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsImageProperties = {
    import DetectLabelsImageProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImageProperties
      .builder()
      .optionallyWith(quality.map(value => value.buildAwsValue()))(_.quality)
      .optionallyWith(
        dominantColors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dominantColors)
      .optionallyWith(foreground.map(value => value.buildAwsValue()))(
        _.foreground
      )
      .optionallyWith(background.map(value => value.buildAwsValue()))(
        _.background
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectLabelsImageProperties.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsImageProperties.wrap(buildAwsValue())
}
object DetectLabelsImageProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImageProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsImageProperties =
      zio.aws.rekognition.model.DetectLabelsImageProperties(
        quality.map(value => value.asEditable),
        dominantColors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        foreground.map(value => value.asEditable),
        background.map(value => value.asEditable)
      )
    def quality
        : Optional[zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly]
    def dominantColors
        : Optional[List[zio.aws.rekognition.model.DominantColor.ReadOnly]]
    def foreground: Optional[
      zio.aws.rekognition.model.DetectLabelsImageForeground.ReadOnly
    ]
    def background: Optional[
      zio.aws.rekognition.model.DetectLabelsImageBackground.ReadOnly
    ]
    def getQuality: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly
    ] = AwsError.unwrapOptionField("quality", quality)
    def getDominantColors: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.DominantColor.ReadOnly
    ]] = AwsError.unwrapOptionField("dominantColors", dominantColors)
    def getForeground: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsImageForeground.ReadOnly
    ] = AwsError.unwrapOptionField("foreground", foreground)
    def getBackground: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsImageBackground.ReadOnly
    ] = AwsError.unwrapOptionField("background", background)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImageProperties
  ) extends zio.aws.rekognition.model.DetectLabelsImageProperties.ReadOnly {
    override val quality: Optional[
      zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.quality())
      .map(value =>
        zio.aws.rekognition.model.DetectLabelsImageQuality.wrap(value)
      )
    override val dominantColors
        : Optional[List[zio.aws.rekognition.model.DominantColor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dominantColors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.DominantColor.wrap(item)
          }.toList
        )
    override val foreground: Optional[
      zio.aws.rekognition.model.DetectLabelsImageForeground.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.foreground())
      .map(value =>
        zio.aws.rekognition.model.DetectLabelsImageForeground.wrap(value)
      )
    override val background: Optional[
      zio.aws.rekognition.model.DetectLabelsImageBackground.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.background())
      .map(value =>
        zio.aws.rekognition.model.DetectLabelsImageBackground.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImageProperties
  ): zio.aws.rekognition.model.DetectLabelsImageProperties.ReadOnly =
    new Wrapper(impl)
}
