package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectFacesRequest(
    image: zio.aws.rekognition.model.Image,
    attributes: Optional[Iterable[zio.aws.rekognition.model.Attribute]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectFacesRequest = {
    import DetectFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectFacesRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectFacesRequest.ReadOnly =
    zio.aws.rekognition.model.DetectFacesRequest.wrap(buildAwsValue())
}
object DetectFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectFacesRequest =
      zio.aws.rekognition.model
        .DetectFacesRequest(image.asEditable, attributes.map(value => value))
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def attributes: Optional[List[zio.aws.rekognition.model.Attribute]]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Attribute]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectFacesRequest
  ) extends zio.aws.rekognition.model.DetectFacesRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val attributes
        : Optional[List[zio.aws.rekognition.model.Attribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Attribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectFacesRequest
  ): zio.aws.rekognition.model.DetectFacesRequest.ReadOnly = new Wrapper(impl)
}
