package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  ClientRequestToken,
  UserId,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(
    collectionId: CollectionId,
    userId: UserId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteUserRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteUserRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteUserRequest =
      zio.aws.rekognition.model.DeleteUserRequest(
        collectionId,
        userId,
        clientRequestToken.map(value => value)
      )
    def collectionId: CollectionId
    def userId: UserId
    def clientRequestToken: Optional[ClientRequestToken]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteUserRequest
  ) extends zio.aws.rekognition.model.DeleteUserRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val userId: UserId =
      zio.aws.rekognition.model.primitives.UserId(impl.userId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteUserRequest
  ): zio.aws.rekognition.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
