package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFacesResponse(
    deletedFaces: Optional[Iterable[FaceId]] = Optional.Absent,
    unsuccessfulFaceDeletions: Optional[
      Iterable[zio.aws.rekognition.model.UnsuccessfulFaceDeletion]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse = {
    import DeleteFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
      .builder()
      .optionallyWith(
        deletedFaces.map(value =>
          value.map { item =>
            FaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deletedFaces)
      .optionallyWith(
        unsuccessfulFaceDeletions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfulFaceDeletions)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly =
    zio.aws.rekognition.model.DeleteFacesResponse.wrap(buildAwsValue())
}
object DeleteFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteFacesResponse =
      zio.aws.rekognition.model.DeleteFacesResponse(
        deletedFaces.map(value => value),
        unsuccessfulFaceDeletions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deletedFaces: Optional[List[FaceId]]
    def unsuccessfulFaceDeletions: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceDeletion.ReadOnly]
    ]
    def getDeletedFaces: ZIO[Any, AwsError, List[FaceId]] =
      AwsError.unwrapOptionField("deletedFaces", deletedFaces)
    def getUnsuccessfulFaceDeletions: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsuccessfulFaceDeletion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfulFaceDeletions",
      unsuccessfulFaceDeletions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
  ) extends zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly {
    override val deletedFaces: Optional[List[FaceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedFaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.FaceId(item)
        }.toList
      )
    override val unsuccessfulFaceDeletions: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceDeletion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unsuccessfulFaceDeletions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.UnsuccessfulFaceDeletion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
  ): zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly = new Wrapper(impl)
}
