package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.UInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DatasetStats(
    labeledEntries: Optional[UInteger] = Optional.Absent,
    totalEntries: Optional[UInteger] = Optional.Absent,
    totalLabels: Optional[UInteger] = Optional.Absent,
    errorEntries: Optional[UInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetStats = {
    import DatasetStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetStats
      .builder()
      .optionallyWith(
        labeledEntries.map(value => UInteger.unwrap(value): Integer)
      )(_.labeledEntries)
      .optionallyWith(
        totalEntries.map(value => UInteger.unwrap(value): Integer)
      )(_.totalEntries)
      .optionallyWith(
        totalLabels.map(value => UInteger.unwrap(value): Integer)
      )(_.totalLabels)
      .optionallyWith(
        errorEntries.map(value => UInteger.unwrap(value): Integer)
      )(_.errorEntries)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetStats.ReadOnly =
    zio.aws.rekognition.model.DatasetStats.wrap(buildAwsValue())
}
object DatasetStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetStats =
      zio.aws.rekognition.model.DatasetStats(
        labeledEntries.map(value => value),
        totalEntries.map(value => value),
        totalLabels.map(value => value),
        errorEntries.map(value => value)
      )
    def labeledEntries: Optional[UInteger]
    def totalEntries: Optional[UInteger]
    def totalLabels: Optional[UInteger]
    def errorEntries: Optional[UInteger]
    def getLabeledEntries: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("labeledEntries", labeledEntries)
    def getTotalEntries: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("totalEntries", totalEntries)
    def getTotalLabels: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("totalLabels", totalLabels)
    def getErrorEntries: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("errorEntries", errorEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetStats
  ) extends zio.aws.rekognition.model.DatasetStats.ReadOnly {
    override val labeledEntries: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.labeledEntries())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val totalEntries: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.totalEntries())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val totalLabels: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.totalLabels())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val errorEntries: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.errorEntries())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetStats
  ): zio.aws.rekognition.model.DatasetStats.ReadOnly = new Wrapper(impl)
}
