package zio.aws.rekognition.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{StatusMessage, DateTime}
import scala.jdk.CollectionConverters._
final case class DatasetDescription(
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    lastUpdatedTimestamp: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.rekognition.model.DatasetStatus] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    statusMessageCode: Optional[
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = Optional.Absent,
    datasetStats: Optional[zio.aws.rekognition.model.DatasetStats] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetDescription = {
    import DatasetDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetDescription
      .builder()
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(statusMessageCode.map(value => value.unwrap))(
        _.statusMessageCode
      )
      .optionallyWith(datasetStats.map(value => value.buildAwsValue()))(
        _.datasetStats
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetDescription.ReadOnly =
    zio.aws.rekognition.model.DatasetDescription.wrap(buildAwsValue())
}
object DatasetDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetDescription =
      zio.aws.rekognition.model.DatasetDescription(
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        statusMessageCode.map(value => value),
        datasetStats.map(value => value.asEditable)
      )
    def creationTimestamp: Optional[DateTime]
    def lastUpdatedTimestamp: Optional[DateTime]
    def status: Optional[zio.aws.rekognition.model.DatasetStatus]
    def statusMessage: Optional[StatusMessage]
    def statusMessageCode
        : Optional[zio.aws.rekognition.model.DatasetStatusMessageCode]
    def datasetStats: Optional[zio.aws.rekognition.model.DatasetStats.ReadOnly]
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getStatus: ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStatusMessageCode: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = AwsError.unwrapOptionField("statusMessageCode", statusMessageCode)
    def getDatasetStats
        : ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetStats.ReadOnly] =
      AwsError.unwrapOptionField("datasetStats", datasetStats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetDescription
  ) extends zio.aws.rekognition.model.DatasetDescription.ReadOnly {
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val lastUpdatedTimestamp: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.rekognition.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rekognition.model.DatasetStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val statusMessageCode
        : Optional[zio.aws.rekognition.model.DatasetStatusMessageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessageCode())
        .map(value =>
          zio.aws.rekognition.model.DatasetStatusMessageCode.wrap(value)
        )
    override val datasetStats
        : Optional[zio.aws.rekognition.model.DatasetStats.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetStats())
        .map(value => zio.aws.rekognition.model.DatasetStats.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetDescription
  ): zio.aws.rekognition.model.DatasetDescription.ReadOnly = new Wrapper(impl)
}
