package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  ClientRequestToken,
  UserId,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUserRequest(
    collectionId: CollectionId,
    userId: UserId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateUserRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateUserRequest.ReadOnly =
    zio.aws.rekognition.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateUserRequest =
      zio.aws.rekognition.model.CreateUserRequest(
        collectionId,
        userId,
        clientRequestToken.map(value => value)
      )
    def collectionId: CollectionId
    def userId: UserId
    def clientRequestToken: Optional[ClientRequestToken]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateUserRequest
  ) extends zio.aws.rekognition.model.CreateUserRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val userId: UserId =
      zio.aws.rekognition.model.primitives.UserId(impl.userId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateUserRequest
  ): zio.aws.rekognition.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
