package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{ClientRequestToken, KmsKeyId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFaceLivenessSessionRequest(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    settings: Optional[
      zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest = {
    import CreateFaceLivenessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateFaceLivenessSessionRequest.ReadOnly =
    zio.aws.rekognition.model.CreateFaceLivenessSessionRequest
      .wrap(buildAwsValue())
}
object CreateFaceLivenessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateFaceLivenessSessionRequest =
      zio.aws.rekognition.model.CreateFaceLivenessSessionRequest(
        kmsKeyId.map(value => value),
        settings.map(value => value.asEditable),
        clientRequestToken.map(value => value)
      )
    def kmsKeyId: Optional[KmsKeyId]
    def settings: Optional[
      zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings.ReadOnly
    ]
    def clientRequestToken: Optional[ClientRequestToken]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest
  ) extends zio.aws.rekognition.model.CreateFaceLivenessSessionRequest.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.rekognition.model.primitives.KmsKeyId(value))
    override val settings: Optional[
      zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings
          .wrap(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest
  ): zio.aws.rekognition.model.CreateFaceLivenessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
