package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{ULong, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContentModerationDetection(
    timestamp: Optional[Timestamp] = Optional.Absent,
    moderationLabel: Optional[zio.aws.rekognition.model.ModerationLabel] =
      Optional.Absent,
    startTimestampMillis: Optional[ULong] = Optional.Absent,
    endTimestampMillis: Optional[ULong] = Optional.Absent,
    durationMillis: Optional[ULong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ContentModerationDetection = {
    import ContentModerationDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(moderationLabel.map(value => value.buildAwsValue()))(
        _.moderationLabel
      )
      .optionallyWith(
        startTimestampMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.startTimestampMillis)
      .optionallyWith(
        endTimestampMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.endTimestampMillis)
      .optionallyWith(
        durationMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ContentModerationDetection.ReadOnly =
    zio.aws.rekognition.model.ContentModerationDetection.wrap(buildAwsValue())
}
object ContentModerationDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ContentModerationDetection =
      zio.aws.rekognition.model.ContentModerationDetection(
        timestamp.map(value => value),
        moderationLabel.map(value => value.asEditable),
        startTimestampMillis.map(value => value),
        endTimestampMillis.map(value => value),
        durationMillis.map(value => value)
      )
    def timestamp: Optional[Timestamp]
    def moderationLabel
        : Optional[zio.aws.rekognition.model.ModerationLabel.ReadOnly]
    def startTimestampMillis: Optional[ULong]
    def endTimestampMillis: Optional[ULong]
    def durationMillis: Optional[ULong]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getModerationLabel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ModerationLabel.ReadOnly
    ] = AwsError.unwrapOptionField("moderationLabel", moderationLabel)
    def getStartTimestampMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("startTimestampMillis", startTimestampMillis)
    def getEndTimestampMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("endTimestampMillis", endTimestampMillis)
    def getDurationMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ) extends zio.aws.rekognition.model.ContentModerationDetection.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val moderationLabel
        : Optional[zio.aws.rekognition.model.ModerationLabel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderationLabel())
        .map(value => zio.aws.rekognition.model.ModerationLabel.wrap(value))
    override val startTimestampMillis: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimestampMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val endTimestampMillis: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.endTimestampMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val durationMillis: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ): zio.aws.rekognition.model.ContentModerationDetection.ReadOnly =
    new Wrapper(impl)
}
