package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociatedFace(faceId: Optional[FaceId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AssociatedFace = {
    import AssociatedFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AssociatedFace
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AssociatedFace.ReadOnly =
    zio.aws.rekognition.model.AssociatedFace.wrap(buildAwsValue())
}
object AssociatedFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AssociatedFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AssociatedFace =
      zio.aws.rekognition.model.AssociatedFace(faceId.map(value => value))
    def faceId: Optional[FaceId]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AssociatedFace
  ) extends zio.aws.rekognition.model.AssociatedFace.ReadOnly {
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AssociatedFace
  ): zio.aws.rekognition.model.AssociatedFace.ReadOnly = new Wrapper(impl)
}
