package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateFacesResponse(
    associatedFaces: Optional[
      Iterable[zio.aws.rekognition.model.AssociatedFace]
    ] = Optional.Absent,
    unsuccessfulFaceAssociations: Optional[
      Iterable[zio.aws.rekognition.model.UnsuccessfulFaceAssociation]
    ] = Optional.Absent,
    userStatus: Optional[zio.aws.rekognition.model.UserStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse = {
    import AssociateFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse
      .builder()
      .optionallyWith(
        associatedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedFaces)
      .optionallyWith(
        unsuccessfulFaceAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfulFaceAssociations)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AssociateFacesResponse.ReadOnly =
    zio.aws.rekognition.model.AssociateFacesResponse.wrap(buildAwsValue())
}
object AssociateFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AssociateFacesResponse =
      zio.aws.rekognition.model.AssociateFacesResponse(
        associatedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessfulFaceAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userStatus.map(value => value)
      )
    def associatedFaces
        : Optional[List[zio.aws.rekognition.model.AssociatedFace.ReadOnly]]
    def unsuccessfulFaceAssociations: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceAssociation.ReadOnly]
    ]
    def userStatus: Optional[zio.aws.rekognition.model.UserStatus]
    def getAssociatedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.AssociatedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedFaces", associatedFaces)
    def getUnsuccessfulFaceAssociations: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsuccessfulFaceAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfulFaceAssociations",
      unsuccessfulFaceAssociations
    )
    def getUserStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.UserStatus] =
      AwsError.unwrapOptionField("userStatus", userStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse
  ) extends zio.aws.rekognition.model.AssociateFacesResponse.ReadOnly {
    override val associatedFaces
        : Optional[List[zio.aws.rekognition.model.AssociatedFace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.AssociatedFace.wrap(item)
          }.toList
        )
    override val unsuccessfulFaceAssociations: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unsuccessfulFaceAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.UnsuccessfulFaceAssociation.wrap(item)
        }.toList
      )
    override val userStatus: Optional[zio.aws.rekognition.model.UserStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStatus())
        .map(value => zio.aws.rekognition.model.UserStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse
  ): zio.aws.rekognition.model.AssociateFacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
