package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  Percent,
  UserId,
  FaceId,
  ClientRequestToken,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateFacesRequest(
    collectionId: CollectionId,
    userId: UserId,
    faceIds: Iterable[FaceId],
    userMatchThreshold: Optional[Percent] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest = {
    import AssociateFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .faceIds(faceIds.map { item =>
        FaceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        userMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.userMatchThreshold)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AssociateFacesRequest.ReadOnly =
    zio.aws.rekognition.model.AssociateFacesRequest.wrap(buildAwsValue())
}
object AssociateFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AssociateFacesRequest =
      zio.aws.rekognition.model.AssociateFacesRequest(
        collectionId,
        userId,
        faceIds,
        userMatchThreshold.map(value => value),
        clientRequestToken.map(value => value)
      )
    def collectionId: CollectionId
    def userId: UserId
    def faceIds: List[FaceId]
    def userMatchThreshold: Optional[Percent]
    def clientRequestToken: Optional[ClientRequestToken]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getFaceIds: ZIO[Any, Nothing, List[FaceId]] = ZIO.succeed(faceIds)
    def getUserMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("userMatchThreshold", userMatchThreshold)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest
  ) extends zio.aws.rekognition.model.AssociateFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val userId: UserId =
      zio.aws.rekognition.model.primitives.UserId(impl.userId())
    override val faceIds: List[FaceId] = impl
      .faceIds()
      .asScala
      .map { item =>
        zio.aws.rekognition.model.primitives.FaceId(item)
      }
      .toList
    override val userMatchThreshold: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.userMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest
  ): zio.aws.rekognition.model.AssociateFacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
