package zio.aws.rekognition
import zio.aws.rekognition.model.DisassociateFacesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.rekognition.model.primitives.{CollectionId, DatasetEntry}
import zio.aws.rekognition.model.{
  DeleteUserRequest,
  DeleteStreamProcessorRequest,
  StartPersonTrackingRequest,
  StartFaceSearchRequest,
  CreateCollectionRequest,
  StopStreamProcessorRequest,
  DeleteProjectPolicyRequest,
  CreateDatasetRequest,
  DetectCustomLabelsRequest,
  CompareFacesRequest,
  DeleteCollectionRequest,
  DetectProtectiveEquipmentRequest,
  CreateProjectRequest,
  DetectLabelsRequest,
  DescribeProjectsRequest,
  GetFaceDetectionRequest,
  DescribeStreamProcessorRequest,
  DeleteFacesRequest,
  ListUsersRequest,
  GetCelebrityInfoRequest,
  StartProjectVersionRequest,
  UpdateStreamProcessorRequest,
  GetSegmentDetectionRequest,
  DetectTextRequest,
  DetectFacesRequest,
  PutProjectPolicyRequest,
  ListFacesRequest,
  CreateFaceLivenessSessionRequest,
  DescribeDatasetRequest,
  CreateStreamProcessorRequest,
  DetectModerationLabelsRequest,
  ListTagsForResourceRequest,
  DescribeCollectionRequest,
  CreateProjectVersionRequest,
  GetLabelDetectionRequest,
  ListStreamProcessorsRequest,
  DistributeDatasetEntriesRequest,
  SearchUsersByImageRequest,
  StartStreamProcessorRequest,
  IndexFacesRequest,
  StartCelebrityRecognitionRequest,
  SearchUsersRequest,
  GetPersonTrackingRequest,
  ListCollectionsRequest,
  DeleteProjectRequest,
  ListDatasetEntriesRequest,
  CreateUserRequest,
  SearchFacesRequest,
  StartFaceDetectionRequest,
  GetContentModerationRequest,
  GetFaceLivenessSessionResultsRequest,
  SearchFacesByImageRequest,
  DeleteDatasetRequest,
  DescribeProjectVersionsRequest,
  RecognizeCelebritiesRequest,
  UntagResourceRequest,
  UpdateDatasetEntriesRequest,
  StartSegmentDetectionRequest,
  StartLabelDetectionRequest,
  AssociateFacesRequest,
  StartContentModerationRequest,
  StartTextDetectionRequest,
  ListProjectPoliciesRequest,
  CopyProjectVersionRequest,
  GetCelebrityRecognitionRequest,
  ListDatasetLabelsRequest,
  GetFaceSearchRequest,
  DeleteProjectVersionRequest,
  StopProjectVersionRequest,
  TagResourceRequest,
  GetTextDetectionRequest,
  DisassociateFacesRequest
}
import zio.stream.ZStream
object RekognitionMock extends Mock[Rekognition] {
  object ListDatasetEntries
      extends Stream[ListDatasetEntriesRequest, AwsError, DatasetEntry]
  object ListDatasetEntriesPaginated
      extends Effect[
        ListDatasetEntriesRequest,
        AwsError,
        zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly
      ]
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly
      ]
  object GetSegmentDetection
      extends Effect[
        GetSegmentDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly
      ]
  object IndexFaces
      extends Effect[
        IndexFacesRequest,
        AwsError,
        zio.aws.rekognition.model.IndexFacesResponse.ReadOnly
      ]
  object UpdateStreamProcessor
      extends Effect[
        UpdateStreamProcessorRequest,
        AwsError,
        zio.aws.rekognition.model.UpdateStreamProcessorResponse.ReadOnly
      ]
  object StartCelebrityRecognition
      extends Effect[
        StartCelebrityRecognitionRequest,
        AwsError,
        zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly
      ]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.rekognition.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.rekognition.model.ListUsersResponse.ReadOnly
      ]
  object SearchUsers
      extends Effect[
        SearchUsersRequest,
        AwsError,
        zio.aws.rekognition.model.SearchUsersResponse.ReadOnly
      ]
  object DistributeDatasetEntries
      extends Effect[
        DistributeDatasetEntriesRequest,
        AwsError,
        zio.aws.rekognition.model.DistributeDatasetEntriesResponse.ReadOnly
      ]
  object DetectText
      extends Effect[
        DetectTextRequest,
        AwsError,
        zio.aws.rekognition.model.DetectTextResponse.ReadOnly
      ]
  object SearchUsersByImage
      extends Effect[
        SearchUsersByImageRequest,
        AwsError,
        zio.aws.rekognition.model.SearchUsersByImageResponse.ReadOnly
      ]
  object DetectCustomLabels
      extends Effect[
        DetectCustomLabelsRequest,
        AwsError,
        zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly
      ]
  object CreateProjectVersion
      extends Effect[
        CreateProjectVersionRequest,
        AwsError,
        zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly
      ]
  object StartTextDetection
      extends Effect[
        StartTextDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.StartTextDetectionResponse.ReadOnly
      ]
  object CreateCollection
      extends Effect[
        CreateCollectionRequest,
        AwsError,
        zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly
      ]
  object SearchFacesByImage
      extends Effect[
        SearchFacesByImageRequest,
        AwsError,
        zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly
      ]
  object SearchFaces
      extends Effect[
        SearchFacesRequest,
        AwsError,
        zio.aws.rekognition.model.SearchFacesResponse.ReadOnly
      ]
  object DescribeProjectVersions
      extends Stream[
        DescribeProjectVersionsRequest,
        AwsError,
        zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly
      ]
  object DescribeProjectVersionsPaginated
      extends Effect[
        DescribeProjectVersionsRequest,
        AwsError,
        zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly
      ]
  object StartProjectVersion
      extends Effect[
        StartProjectVersionRequest,
        AwsError,
        zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly
      ]
  object DeleteCollection
      extends Effect[
        DeleteCollectionRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly
      ]
  object UpdateDatasetEntries
      extends Effect[
        UpdateDatasetEntriesRequest,
        AwsError,
        zio.aws.rekognition.model.UpdateDatasetEntriesResponse.ReadOnly
      ]
  object DescribeCollection
      extends Effect[
        DescribeCollectionRequest,
        AwsError,
        zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly
      ]
  object GetPersonTracking
      extends Effect[GetPersonTrackingRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly,
        zio.aws.rekognition.model.PersonDetection.ReadOnly
      ]]
  object GetPersonTrackingPaginated
      extends Effect[
        GetPersonTrackingRequest,
        AwsError,
        zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly
      ]
  object GetFaceDetection
      extends Effect[GetFaceDetectionRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly,
        zio.aws.rekognition.model.FaceDetection.ReadOnly
      ]]
  object GetFaceDetectionPaginated
      extends Effect[
        GetFaceDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly
      ]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly
      ]
  object DetectFaces
      extends Effect[
        DetectFacesRequest,
        AwsError,
        zio.aws.rekognition.model.DetectFacesResponse.ReadOnly
      ]
  object StartFaceSearch
      extends Effect[
        StartFaceSearchRequest,
        AwsError,
        zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.rekognition.model.CreateUserResponse.ReadOnly
      ]
  object DeleteFaces
      extends Effect[
        DeleteFacesRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly
      ]
  object ListProjectPolicies
      extends Stream[
        ListProjectPoliciesRequest,
        AwsError,
        zio.aws.rekognition.model.ProjectPolicy.ReadOnly
      ]
  object ListProjectPoliciesPaginated
      extends Effect[
        ListProjectPoliciesRequest,
        AwsError,
        zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly
      ]
  object CompareFaces
      extends Effect[
        CompareFacesRequest,
        AwsError,
        zio.aws.rekognition.model.CompareFacesResponse.ReadOnly
      ]
  object GetTextDetection
      extends Effect[GetTextDetectionRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly,
        zio.aws.rekognition.model.TextDetectionResult.ReadOnly
      ]]
  object GetTextDetectionPaginated
      extends Effect[
        GetTextDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly
      ]
  object CreateStreamProcessor
      extends Effect[
        CreateStreamProcessorRequest,
        AwsError,
        zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly
      ]
  object CreateFaceLivenessSession
      extends Effect[
        CreateFaceLivenessSessionRequest,
        AwsError,
        zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly
      ]
  object DescribeStreamProcessor
      extends Effect[
        DescribeStreamProcessorRequest,
        AwsError,
        zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly
      ]
  object DetectLabels
      extends Effect[
        DetectLabelsRequest,
        AwsError,
        zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.rekognition.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.rekognition.model.CreateProjectResponse.ReadOnly
      ]
  object CopyProjectVersion
      extends Effect[
        CopyProjectVersionRequest,
        AwsError,
        zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly
      ]
  object DeleteStreamProcessor
      extends Effect[
        DeleteStreamProcessorRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteStreamProcessorResponse.ReadOnly
      ]
  object GetFaceLivenessSessionResults
      extends Effect[
        GetFaceLivenessSessionResultsRequest,
        AwsError,
        zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly
      ]
  object StopProjectVersion
      extends Effect[
        StopProjectVersionRequest,
        AwsError,
        zio.aws.rekognition.model.StopProjectVersionResponse.ReadOnly
      ]
  object StopStreamProcessor
      extends Effect[
        StopStreamProcessorRequest,
        AwsError,
        zio.aws.rekognition.model.StopStreamProcessorResponse.ReadOnly
      ]
  object ListFaces
      extends Effect[ListFacesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.rekognition.model.ListFacesResponse.ReadOnly,
        zio.aws.rekognition.model.Face.ReadOnly
      ]]
  object ListFacesPaginated
      extends Effect[
        ListFacesRequest,
        AwsError,
        zio.aws.rekognition.model.ListFacesResponse.ReadOnly
      ]
  object PutProjectPolicy
      extends Effect[
        PutProjectPolicyRequest,
        AwsError,
        zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly
      ]
  object StartStreamProcessor
      extends Effect[
        StartStreamProcessorRequest,
        AwsError,
        zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly
      ]
  object StartPersonTracking
      extends Effect[
        StartPersonTrackingRequest,
        AwsError,
        zio.aws.rekognition.model.StartPersonTrackingResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.rekognition.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListStreamProcessors
      extends Stream[
        ListStreamProcessorsRequest,
        AwsError,
        zio.aws.rekognition.model.StreamProcessor.ReadOnly
      ]
  object ListStreamProcessorsPaginated
      extends Effect[
        ListStreamProcessorsRequest,
        AwsError,
        zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.rekognition.model.TagResourceResponse.ReadOnly
      ]
  object ListDatasetLabels
      extends Stream[
        ListDatasetLabelsRequest,
        AwsError,
        zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly
      ]
  object ListDatasetLabelsPaginated
      extends Effect[
        ListDatasetLabelsRequest,
        AwsError,
        zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly
      ]
  object DetectProtectiveEquipment
      extends Effect[
        DetectProtectiveEquipmentRequest,
        AwsError,
        zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly
      ]
  object DeleteUser
      extends Effect[
        DeleteUserRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteUserResponse.ReadOnly
      ]
  object DeleteProjectPolicy
      extends Effect[
        DeleteProjectPolicyRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteProjectPolicyResponse.ReadOnly
      ]
  object StartFaceDetection
      extends Effect[
        StartFaceDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly
      ]
  object ListCollections
      extends Stream[ListCollectionsRequest, AwsError, CollectionId]
  object ListCollectionsPaginated
      extends Effect[
        ListCollectionsRequest,
        AwsError,
        zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly
      ]
  object DescribeProjects
      extends Stream[
        DescribeProjectsRequest,
        AwsError,
        zio.aws.rekognition.model.ProjectDescription.ReadOnly
      ]
  object DescribeProjectsPaginated
      extends Effect[
        DescribeProjectsRequest,
        AwsError,
        zio.aws.rekognition.model.DescribeProjectsResponse.ReadOnly
      ]
  object AssociateFaces
      extends Effect[
        AssociateFacesRequest,
        AwsError,
        zio.aws.rekognition.model.AssociateFacesResponse.ReadOnly
      ]
  object GetFaceSearch
      extends Effect[GetFaceSearchRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly,
        zio.aws.rekognition.model.PersonMatch.ReadOnly
      ]]
  object GetFaceSearchPaginated
      extends Effect[
        GetFaceSearchRequest,
        AwsError,
        zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly
      ]
  object DetectModerationLabels
      extends Effect[
        DetectModerationLabelsRequest,
        AwsError,
        zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly
      ]
  object StartSegmentDetection
      extends Effect[
        StartSegmentDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteDatasetResponse.ReadOnly
      ]
  object StartContentModeration
      extends Effect[
        StartContentModerationRequest,
        AwsError,
        zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly
      ]
  object GetCelebrityInfo
      extends Effect[
        GetCelebrityInfoRequest,
        AwsError,
        zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly
      ]
  object StartLabelDetection
      extends Effect[
        StartLabelDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly
      ]
  object RecognizeCelebrities
      extends Effect[
        RecognizeCelebritiesRequest,
        AwsError,
        zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly
      ]
  object GetContentModeration
      extends Effect[
        GetContentModerationRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly,
          zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
        ]
      ]
  object GetContentModerationPaginated
      extends Effect[
        GetContentModerationRequest,
        AwsError,
        zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly
      ]
  object GetLabelDetection
      extends Effect[GetLabelDetectionRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly,
        zio.aws.rekognition.model.LabelDetection.ReadOnly
      ]]
  object GetLabelDetectionPaginated
      extends Effect[
        GetLabelDetectionRequest,
        AwsError,
        zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly
      ]
  object DisassociateFaces
      extends Effect[DisassociateFacesRequest, AwsError, ReadOnly]
  object DeleteProjectVersion
      extends Effect[
        DeleteProjectVersionRequest,
        AwsError,
        zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly
      ]
  object GetCelebrityRecognition
      extends Effect[
        GetCelebrityRecognitionRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly,
          zio.aws.rekognition.model.CelebrityRecognition.ReadOnly
        ]
      ]
  object GetCelebrityRecognitionPaginated
      extends Effect[
        GetCelebrityRecognitionRequest,
        AwsError,
        zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Rekognition] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Rekognition] { rts =>
        ZIO.succeed {
          new Rekognition {
            val api: RekognitionAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Rekognition = this
            def listDatasetEntries(
                request: ListDatasetEntriesRequest
            ): ZStream[Any, AwsError, DatasetEntry] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDatasetEntries, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDatasetEntriesPaginated(
                request: ListDatasetEntriesRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly
            ] = proxy(ListDatasetEntriesPaginated, request)
            def createDataset(request: CreateDatasetRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly
            ] = proxy(CreateDataset, request)
            def getSegmentDetection(request: GetSegmentDetectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly
            ] = proxy(GetSegmentDetection, request)
            def indexFaces(request: IndexFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.IndexFacesResponse.ReadOnly
            ] = proxy(IndexFaces, request)
            def updateStreamProcessor(
                request: UpdateStreamProcessorRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.UpdateStreamProcessorResponse.ReadOnly
            ] = proxy(UpdateStreamProcessor, request)
            def startCelebrityRecognition(
                request: StartCelebrityRecognitionRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly
            ] = proxy(StartCelebrityRecognition, request)
            def listUsers(
                request: ListUsersRequest
            ): ZStream[Any, AwsError, zio.aws.rekognition.model.User.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListUsers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listUsersPaginated(request: ListUsersRequest): IO[
              AwsError,
              zio.aws.rekognition.model.ListUsersResponse.ReadOnly
            ] = proxy(ListUsersPaginated, request)
            def searchUsers(request: SearchUsersRequest): IO[
              AwsError,
              zio.aws.rekognition.model.SearchUsersResponse.ReadOnly
            ] = proxy(SearchUsers, request)
            def distributeDatasetEntries(
                request: DistributeDatasetEntriesRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.DistributeDatasetEntriesResponse.ReadOnly
            ] = proxy(DistributeDatasetEntries, request)
            def detectText(request: DetectTextRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DetectTextResponse.ReadOnly
            ] = proxy(DetectText, request)
            def searchUsersByImage(request: SearchUsersByImageRequest): IO[
              AwsError,
              zio.aws.rekognition.model.SearchUsersByImageResponse.ReadOnly
            ] = proxy(SearchUsersByImage, request)
            def detectCustomLabels(request: DetectCustomLabelsRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly
            ] = proxy(DetectCustomLabels, request)
            def createProjectVersion(request: CreateProjectVersionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly
            ] = proxy(CreateProjectVersion, request)
            def startTextDetection(request: StartTextDetectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartTextDetectionResponse.ReadOnly
            ] = proxy(StartTextDetection, request)
            def createCollection(request: CreateCollectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly
            ] = proxy(CreateCollection, request)
            def searchFacesByImage(request: SearchFacesByImageRequest): IO[
              AwsError,
              zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly
            ] = proxy(SearchFacesByImage, request)
            def searchFaces(request: SearchFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.SearchFacesResponse.ReadOnly
            ] = proxy(SearchFaces, request)
            def describeProjectVersions(
                request: DescribeProjectVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeProjectVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeProjectVersionsPaginated(
                request: DescribeProjectVersionsRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly
            ] = proxy(DescribeProjectVersionsPaginated, request)
            def startProjectVersion(request: StartProjectVersionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly
            ] = proxy(StartProjectVersion, request)
            def deleteCollection(request: DeleteCollectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly
            ] = proxy(DeleteCollection, request)
            def updateDatasetEntries(request: UpdateDatasetEntriesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.UpdateDatasetEntriesResponse.ReadOnly
            ] = proxy(UpdateDatasetEntries, request)
            def describeCollection(request: DescribeCollectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly
            ] = proxy(DescribeCollection, request)
            def getPersonTracking(
                request: GetPersonTrackingRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly,
              zio.aws.rekognition.model.PersonDetection.ReadOnly
            ]] = proxy(GetPersonTracking, request)
            def getPersonTrackingPaginated(
                request: GetPersonTrackingRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly
            ] = proxy(GetPersonTrackingPaginated, request)
            def getFaceDetection(
                request: GetFaceDetectionRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly,
              zio.aws.rekognition.model.FaceDetection.ReadOnly
            ]] = proxy(GetFaceDetection, request)
            def getFaceDetectionPaginated(request: GetFaceDetectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly
            ] = proxy(GetFaceDetectionPaginated, request)
            def describeDataset(request: DescribeDatasetRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly
            ] = proxy(DescribeDataset, request)
            def detectFaces(request: DetectFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DetectFacesResponse.ReadOnly
            ] = proxy(DetectFaces, request)
            def startFaceSearch(request: StartFaceSearchRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly
            ] = proxy(StartFaceSearch, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def deleteFaces(request: DeleteFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly
            ] = proxy(DeleteFaces, request)
            def listProjectPolicies(
                request: ListProjectPoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.rekognition.model.ProjectPolicy.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProjectPolicies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProjectPoliciesPaginated(
                request: ListProjectPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly
            ] = proxy(ListProjectPoliciesPaginated, request)
            def compareFaces(request: CompareFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CompareFacesResponse.ReadOnly
            ] = proxy(CompareFaces, request)
            def getTextDetection(
                request: GetTextDetectionRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly,
              zio.aws.rekognition.model.TextDetectionResult.ReadOnly
            ]] = proxy(GetTextDetection, request)
            def getTextDetectionPaginated(request: GetTextDetectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly
            ] = proxy(GetTextDetectionPaginated, request)
            def createStreamProcessor(
                request: CreateStreamProcessorRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly
            ] = proxy(CreateStreamProcessor, request)
            def createFaceLivenessSession(
                request: CreateFaceLivenessSessionRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly
            ] = proxy(CreateFaceLivenessSession, request)
            def describeStreamProcessor(
                request: DescribeStreamProcessorRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly
            ] = proxy(DescribeStreamProcessor, request)
            def detectLabels(request: DetectLabelsRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly
            ] = proxy(DetectLabels, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.rekognition.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def copyProjectVersion(request: CopyProjectVersionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly
            ] = proxy(CopyProjectVersion, request)
            def deleteStreamProcessor(
                request: DeleteStreamProcessorRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteStreamProcessorResponse.ReadOnly
            ] = proxy(DeleteStreamProcessor, request)
            def getFaceLivenessSessionResults(
                request: GetFaceLivenessSessionResultsRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly
            ] = proxy(GetFaceLivenessSessionResults, request)
            def stopProjectVersion(request: StopProjectVersionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StopProjectVersionResponse.ReadOnly
            ] = proxy(StopProjectVersion, request)
            def stopStreamProcessor(request: StopStreamProcessorRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StopStreamProcessorResponse.ReadOnly
            ] = proxy(StopStreamProcessor, request)
            def listFaces(
                request: ListFacesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.ListFacesResponse.ReadOnly,
              zio.aws.rekognition.model.Face.ReadOnly
            ]] = proxy(ListFaces, request)
            def listFacesPaginated(request: ListFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.ListFacesResponse.ReadOnly
            ] = proxy(ListFacesPaginated, request)
            def putProjectPolicy(request: PutProjectPolicyRequest): IO[
              AwsError,
              zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly
            ] = proxy(PutProjectPolicy, request)
            def startStreamProcessor(request: StartStreamProcessorRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly
            ] = proxy(StartStreamProcessor, request)
            def startPersonTracking(request: StartPersonTrackingRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartPersonTrackingResponse.ReadOnly
            ] = proxy(StartPersonTracking, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.rekognition.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listStreamProcessors(
                request: ListStreamProcessorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.rekognition.model.StreamProcessor.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStreamProcessors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStreamProcessorsPaginated(
                request: ListStreamProcessorsRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly
            ] = proxy(ListStreamProcessorsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.rekognition.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listDatasetLabels(request: ListDatasetLabelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasetLabels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetLabelsPaginated(
                request: ListDatasetLabelsRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly
            ] = proxy(ListDatasetLabelsPaginated, request)
            def detectProtectiveEquipment(
                request: DetectProtectiveEquipmentRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly
            ] = proxy(DetectProtectiveEquipment, request)
            def deleteUser(request: DeleteUserRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteUserResponse.ReadOnly
            ] = proxy(DeleteUser, request)
            def deleteProjectPolicy(request: DeleteProjectPolicyRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteProjectPolicyResponse.ReadOnly
            ] = proxy(DeleteProjectPolicy, request)
            def startFaceDetection(request: StartFaceDetectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly
            ] = proxy(StartFaceDetection, request)
            def listCollections(
                request: ListCollectionsRequest
            ): ZStream[Any, AwsError, CollectionId] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListCollections, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listCollectionsPaginated(request: ListCollectionsRequest): IO[
              AwsError,
              zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly
            ] = proxy(ListCollectionsPaginated, request)
            def describeProjects(request: DescribeProjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.rekognition.model.ProjectDescription.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeProjects, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeProjectsPaginated(request: DescribeProjectsRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DescribeProjectsResponse.ReadOnly
            ] = proxy(DescribeProjectsPaginated, request)
            def associateFaces(request: AssociateFacesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.AssociateFacesResponse.ReadOnly
            ] = proxy(AssociateFaces, request)
            def getFaceSearch(
                request: GetFaceSearchRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly,
              zio.aws.rekognition.model.PersonMatch.ReadOnly
            ]] = proxy(GetFaceSearch, request)
            def getFaceSearchPaginated(request: GetFaceSearchRequest): IO[
              AwsError,
              zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly
            ] = proxy(GetFaceSearchPaginated, request)
            def detectModerationLabels(
                request: DetectModerationLabelsRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly
            ] = proxy(DetectModerationLabels, request)
            def startSegmentDetection(
                request: StartSegmentDetectionRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly
            ] = proxy(StartSegmentDetection, request)
            def deleteDataset(request: DeleteDatasetRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteDatasetResponse.ReadOnly
            ] = proxy(DeleteDataset, request)
            def startContentModeration(
                request: StartContentModerationRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly
            ] = proxy(StartContentModeration, request)
            def getCelebrityInfo(request: GetCelebrityInfoRequest): IO[
              AwsError,
              zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly
            ] = proxy(GetCelebrityInfo, request)
            def deleteProject(request: DeleteProjectRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly
            ] = proxy(DeleteProject, request)
            def startLabelDetection(request: StartLabelDetectionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly
            ] = proxy(StartLabelDetection, request)
            def recognizeCelebrities(request: RecognizeCelebritiesRequest): IO[
              AwsError,
              zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly
            ] = proxy(RecognizeCelebrities, request)
            def getContentModeration(
                request: GetContentModerationRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly,
              zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
            ]] = proxy(GetContentModeration, request)
            def getContentModerationPaginated(
                request: GetContentModerationRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly
            ] = proxy(GetContentModerationPaginated, request)
            def getLabelDetection(
                request: GetLabelDetectionRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly,
              zio.aws.rekognition.model.LabelDetection.ReadOnly
            ]] = proxy(GetLabelDetection, request)
            def getLabelDetectionPaginated(
                request: GetLabelDetectionRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly
            ] = proxy(GetLabelDetectionPaginated, request)
            def disassociateFaces(
                request: DisassociateFacesRequest
            ): IO[AwsError, ReadOnly] = proxy(DisassociateFaces, request)
            def deleteProjectVersion(request: DeleteProjectVersionRequest): IO[
              AwsError,
              zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly
            ] = proxy(DeleteProjectVersion, request)
            def getCelebrityRecognition(
                request: GetCelebrityRecognitionRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly,
              zio.aws.rekognition.model.CelebrityRecognition.ReadOnly
            ]] = proxy(GetCelebrityRecognition, request)
            def getCelebrityRecognitionPaginated(
                request: GetCelebrityRecognitionRequest
            ): IO[
              AwsError,
              zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly
            ] = proxy(GetCelebrityRecognitionPaginated, request)
          }
        }
      }
    }
  }
}
