package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessingStartSelector(
    kvsStreamStartSelector: Optional[
      zio.aws.rekognition.model.KinesisVideoStreamStartSelector
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessingStartSelector = {
    import StreamProcessingStartSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessingStartSelector
      .builder()
      .optionallyWith(
        kvsStreamStartSelector.map(value => value.buildAwsValue())
      )(_.kvsStreamStartSelector)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StreamProcessingStartSelector.ReadOnly =
    zio.aws.rekognition.model.StreamProcessingStartSelector
      .wrap(buildAwsValue())
}
object StreamProcessingStartSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessingStartSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessingStartSelector =
      zio.aws.rekognition.model.StreamProcessingStartSelector(
        kvsStreamStartSelector.map(value => value.asEditable)
      )
    def kvsStreamStartSelector: Optional[
      zio.aws.rekognition.model.KinesisVideoStreamStartSelector.ReadOnly
    ]
    def getKvsStreamStartSelector: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.KinesisVideoStreamStartSelector.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kvsStreamStartSelector",
      kvsStreamStartSelector
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessingStartSelector
  ) extends zio.aws.rekognition.model.StreamProcessingStartSelector.ReadOnly {
    override val kvsStreamStartSelector: Optional[
      zio.aws.rekognition.model.KinesisVideoStreamStartSelector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kvsStreamStartSelector())
      .map(value =>
        zio.aws.rekognition.model.KinesisVideoStreamStartSelector.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessingStartSelector
  ): zio.aws.rekognition.model.StreamProcessingStartSelector.ReadOnly =
    new Wrapper(impl)
}
