package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{JobTag, ClientRequestToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTextDetectionRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    notificationChannel: Optional[
      zio.aws.rekognition.model.NotificationChannel
    ] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent,
    filters: Optional[zio.aws.rekognition.model.StartTextDetectionFilters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest = {
    import StartTextDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartTextDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.StartTextDetectionRequest.wrap(buildAwsValue())
}
object StartTextDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartTextDetectionRequest =
      zio.aws.rekognition.model.StartTextDetectionRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value),
        filters.map(value => value.asEditable)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Optional[JobTag]
    def filters
        : Optional[zio.aws.rekognition.model.StartTextDetectionFilters.ReadOnly]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StartTextDetectionFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
  ) extends zio.aws.rekognition.model.StartTextDetectionRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
    override val notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationChannel())
        .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
    override val filters: Optional[
      zio.aws.rekognition.model.StartTextDetectionFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.rekognition.model.StartTextDetectionFilters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
  ): zio.aws.rekognition.model.StartTextDetectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
