package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartProjectVersionResponse(
    status: Optional[zio.aws.rekognition.model.ProjectVersionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse = {
    import StartProjectVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly =
    zio.aws.rekognition.model.StartProjectVersionResponse.wrap(buildAwsValue())
}
object StartProjectVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartProjectVersionResponse =
      zio.aws.rekognition.model
        .StartProjectVersionResponse(status.map(value => value))
    def status: Optional[zio.aws.rekognition.model.ProjectVersionStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ProjectVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse
  ) extends zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly {
    override val status
        : Optional[zio.aws.rekognition.model.ProjectVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rekognition.model.ProjectVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse
  ): zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly =
    new Wrapper(impl)
}
