package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFacesResponse(
    faces: Optional[Iterable[zio.aws.rekognition.model.Face]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListFacesResponse = {
    import ListFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListFacesResponse
      .builder()
      .optionallyWith(
        faces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faces)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListFacesResponse.ReadOnly =
    zio.aws.rekognition.model.ListFacesResponse.wrap(buildAwsValue())
}
object ListFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListFacesResponse =
      zio.aws.rekognition.model.ListFacesResponse(
        faces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        faceModelVersion.map(value => value)
      )
    def faces: Optional[List[zio.aws.rekognition.model.Face.ReadOnly]]
    def nextToken: Optional[String]
    def faceModelVersion: Optional[String]
    def getFaces
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Face.ReadOnly]] =
      AwsError.unwrapOptionField("faces", faces)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesResponse
  ) extends zio.aws.rekognition.model.ListFacesResponse.ReadOnly {
    override val faces
        : Optional[List[zio.aws.rekognition.model.Face.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Face.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesResponse
  ): zio.aws.rekognition.model.ListFacesResponse.ReadOnly = new Wrapper(impl)
}
