package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  ExtendedPaginationToken,
  DatasetEntry
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDatasetEntriesResponse(
    datasetEntries: Optional[Iterable[DatasetEntry]] = Optional.Absent,
    nextToken: Optional[ExtendedPaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse = {
    import ListDatasetEntriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse
      .builder()
      .optionallyWith(
        datasetEntries.map(value =>
          value.map { item =>
            DatasetEntry.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.datasetEntries)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly =
    zio.aws.rekognition.model.ListDatasetEntriesResponse.wrap(buildAwsValue())
}
object ListDatasetEntriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListDatasetEntriesResponse =
      zio.aws.rekognition.model.ListDatasetEntriesResponse(
        datasetEntries.map(value => value),
        nextToken.map(value => value)
      )
    def datasetEntries: Optional[List[DatasetEntry]]
    def nextToken: Optional[ExtendedPaginationToken]
    def getDatasetEntries: ZIO[Any, AwsError, List[DatasetEntry]] =
      AwsError.unwrapOptionField("datasetEntries", datasetEntries)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse
  ) extends zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly {
    override val datasetEntries: Optional[List[DatasetEntry]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.DatasetEntry(item)
          }.toList
        )
    override val nextToken: Optional[ExtendedPaginationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse
  ): zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly =
    new Wrapper(impl)
}
