package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LabelDetectionSettings(
    generalLabels: Optional[zio.aws.rekognition.model.GeneralLabelsSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.LabelDetectionSettings = {
    import LabelDetectionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.LabelDetectionSettings
      .builder()
      .optionallyWith(generalLabels.map(value => value.buildAwsValue()))(
        _.generalLabels
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.LabelDetectionSettings.ReadOnly =
    zio.aws.rekognition.model.LabelDetectionSettings.wrap(buildAwsValue())
}
object LabelDetectionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.LabelDetectionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.LabelDetectionSettings =
      zio.aws.rekognition.model
        .LabelDetectionSettings(generalLabels.map(value => value.asEditable))
    def generalLabels
        : Optional[zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly]
    def getGeneralLabels: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("generalLabels", generalLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.LabelDetectionSettings
  ) extends zio.aws.rekognition.model.LabelDetectionSettings.ReadOnly {
    override val generalLabels
        : Optional[zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generalLabels())
        .map(value =>
          zio.aws.rekognition.model.GeneralLabelsSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.LabelDetectionSettings
  ): zio.aws.rekognition.model.LabelDetectionSettings.ReadOnly = new Wrapper(
    impl
  )
}
