package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Label(
    name: Optional[String] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    instances: Optional[Iterable[zio.aws.rekognition.model.Instance]] =
      Optional.Absent,
    parents: Optional[Iterable[zio.aws.rekognition.model.Parent]] =
      Optional.Absent,
    aliases: Optional[Iterable[zio.aws.rekognition.model.LabelAlias]] =
      Optional.Absent,
    categories: Optional[Iterable[zio.aws.rekognition.model.LabelCategory]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Label = {
    import Label.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Label
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        parents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parents)
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categories)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Label.ReadOnly =
    zio.aws.rekognition.model.Label.wrap(buildAwsValue())
}
object Label {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Label] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Label =
      zio.aws.rekognition.model.Label(
        name.map(value => value),
        confidence.map(value => value),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categories.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[String]
    def confidence: Optional[Percent]
    def instances: Optional[List[zio.aws.rekognition.model.Instance.ReadOnly]]
    def parents: Optional[List[zio.aws.rekognition.model.Parent.ReadOnly]]
    def aliases: Optional[List[zio.aws.rekognition.model.LabelAlias.ReadOnly]]
    def categories
        : Optional[List[zio.aws.rekognition.model.LabelCategory.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getParents
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Parent.ReadOnly]] =
      AwsError.unwrapOptionField("parents", parents)
    def getAliases: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.LabelAlias.ReadOnly
    ]] = AwsError.unwrapOptionField("aliases", aliases)
    def getCategories: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.LabelCategory.ReadOnly
    ]] = AwsError.unwrapOptionField("categories", categories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Label
  ) extends zio.aws.rekognition.model.Label.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val instances
        : Optional[List[zio.aws.rekognition.model.Instance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Instance.wrap(item)
          }.toList
        )
    override val parents
        : Optional[List[zio.aws.rekognition.model.Parent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Parent.wrap(item)
          }.toList
        )
    override val aliases
        : Optional[List[zio.aws.rekognition.model.LabelAlias.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.LabelAlias.wrap(item)
          }.toList
        )
    override val categories
        : Optional[List[zio.aws.rekognition.model.LabelCategory.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.LabelCategory.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Label
  ): zio.aws.rekognition.model.Label.ReadOnly = new Wrapper(impl)
}
