package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.GeneralLabelsFilterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GeneralLabelsSettings(
    labelInclusionFilters: Optional[Iterable[GeneralLabelsFilterValue]] =
      Optional.Absent,
    labelExclusionFilters: Optional[Iterable[GeneralLabelsFilterValue]] =
      Optional.Absent,
    labelCategoryInclusionFilters: Optional[
      Iterable[GeneralLabelsFilterValue]
    ] = Optional.Absent,
    labelCategoryExclusionFilters: Optional[
      Iterable[GeneralLabelsFilterValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GeneralLabelsSettings = {
    import GeneralLabelsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GeneralLabelsSettings
      .builder()
      .optionallyWith(
        labelInclusionFilters.map(value =>
          value.map { item =>
            GeneralLabelsFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labelInclusionFilters)
      .optionallyWith(
        labelExclusionFilters.map(value =>
          value.map { item =>
            GeneralLabelsFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labelExclusionFilters)
      .optionallyWith(
        labelCategoryInclusionFilters.map(value =>
          value.map { item =>
            GeneralLabelsFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labelCategoryInclusionFilters)
      .optionallyWith(
        labelCategoryExclusionFilters.map(value =>
          value.map { item =>
            GeneralLabelsFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labelCategoryExclusionFilters)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly =
    zio.aws.rekognition.model.GeneralLabelsSettings.wrap(buildAwsValue())
}
object GeneralLabelsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GeneralLabelsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GeneralLabelsSettings =
      zio.aws.rekognition.model.GeneralLabelsSettings(
        labelInclusionFilters.map(value => value),
        labelExclusionFilters.map(value => value),
        labelCategoryInclusionFilters.map(value => value),
        labelCategoryExclusionFilters.map(value => value)
      )
    def labelInclusionFilters: Optional[List[GeneralLabelsFilterValue]]
    def labelExclusionFilters: Optional[List[GeneralLabelsFilterValue]]
    def labelCategoryInclusionFilters: Optional[List[GeneralLabelsFilterValue]]
    def labelCategoryExclusionFilters: Optional[List[GeneralLabelsFilterValue]]
    def getLabelInclusionFilters
        : ZIO[Any, AwsError, List[GeneralLabelsFilterValue]] =
      AwsError.unwrapOptionField("labelInclusionFilters", labelInclusionFilters)
    def getLabelExclusionFilters
        : ZIO[Any, AwsError, List[GeneralLabelsFilterValue]] =
      AwsError.unwrapOptionField("labelExclusionFilters", labelExclusionFilters)
    def getLabelCategoryInclusionFilters
        : ZIO[Any, AwsError, List[GeneralLabelsFilterValue]] =
      AwsError.unwrapOptionField(
        "labelCategoryInclusionFilters",
        labelCategoryInclusionFilters
      )
    def getLabelCategoryExclusionFilters
        : ZIO[Any, AwsError, List[GeneralLabelsFilterValue]] =
      AwsError.unwrapOptionField(
        "labelCategoryExclusionFilters",
        labelCategoryExclusionFilters
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GeneralLabelsSettings
  ) extends zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly {
    override val labelInclusionFilters
        : Optional[List[GeneralLabelsFilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.labelInclusionFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.GeneralLabelsFilterValue(item)
        }.toList
      )
    override val labelExclusionFilters
        : Optional[List[GeneralLabelsFilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.labelExclusionFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.GeneralLabelsFilterValue(item)
        }.toList
      )
    override val labelCategoryInclusionFilters
        : Optional[List[GeneralLabelsFilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.labelCategoryInclusionFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.GeneralLabelsFilterValue(item)
        }.toList
      )
    override val labelCategoryExclusionFilters
        : Optional[List[GeneralLabelsFilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.labelCategoryExclusionFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.GeneralLabelsFilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GeneralLabelsSettings
  ): zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly = new Wrapper(
    impl
  )
}
