package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait DetectLabelsFeatureName {
  def unwrap: software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName
}
object DetectLabelsFeatureName {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName
  ): zio.aws.rekognition.model.DetectLabelsFeatureName = value match {
    case software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName.GENERAL_LABELS =>
      val r = GENERAL_LABELS
      r
    case software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName.IMAGE_PROPERTIES =>
      val r = IMAGE_PROPERTIES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.DetectLabelsFeatureName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName =
      software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName.UNKNOWN_TO_SDK_VERSION
  }
  case object GENERAL_LABELS
      extends zio.aws.rekognition.model.DetectLabelsFeatureName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName =
      software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName.GENERAL_LABELS
  }
  case object IMAGE_PROPERTIES
      extends zio.aws.rekognition.model.DetectLabelsFeatureName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName =
      software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName.IMAGE_PROPERTIES
  }
}
