package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDatasetRequest(datasetArn: DatasetArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest
      .builder()
      .datasetArn(DatasetArn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteDatasetRequest =
      zio.aws.rekognition.model.DeleteDatasetRequest(datasetArn)
    def datasetArn: DatasetArn
    def getDatasetArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest
  ) extends zio.aws.rekognition.model.DeleteDatasetRequest.ReadOnly {
    override val datasetArn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest
  ): zio.aws.rekognition.model.DeleteDatasetRequest.ReadOnly = new Wrapper(impl)
}
