package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  RoleArn,
  TagValue,
  StreamProcessorName,
  KmsKeyId,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStreamProcessorRequest(
    input: zio.aws.rekognition.model.StreamProcessorInput,
    output: zio.aws.rekognition.model.StreamProcessorOutput,
    name: StreamProcessorName,
    settings: zio.aws.rekognition.model.StreamProcessorSettings,
    roleArn: RoleArn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    notificationChannel: Optional[
      zio.aws.rekognition.model.StreamProcessorNotificationChannel
    ] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    regionsOfInterest: Optional[
      Iterable[zio.aws.rekognition.model.RegionOfInterest]
    ] = Optional.Absent,
    dataSharingPreference: Optional[
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest = {
    import CreateStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
      .builder()
      .input(input.buildAwsValue())
      .output(output.buildAwsValue())
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .settings(settings.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        regionsOfInterest.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regionsOfInterest)
      .optionallyWith(
        dataSharingPreference.map(value => value.buildAwsValue())
      )(_.dataSharingPreference)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.CreateStreamProcessorRequest.wrap(buildAwsValue())
}
object CreateStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateStreamProcessorRequest =
      zio.aws.rekognition.model.CreateStreamProcessorRequest(
        input.asEditable,
        output.asEditable,
        name,
        settings.asEditable,
        roleArn,
        tags.map(value => value),
        notificationChannel.map(value => value.asEditable),
        kmsKeyId.map(value => value),
        regionsOfInterest.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSharingPreference.map(value => value.asEditable)
      )
    def input: zio.aws.rekognition.model.StreamProcessorInput.ReadOnly
    def output: zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly
    def name: StreamProcessorName
    def settings: zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly
    def roleArn: RoleArn
    def tags: Optional[Map[TagKey, TagValue]]
    def notificationChannel: Optional[
      zio.aws.rekognition.model.StreamProcessorNotificationChannel.ReadOnly
    ]
    def kmsKeyId: Optional[KmsKeyId]
    def regionsOfInterest
        : Optional[List[zio.aws.rekognition.model.RegionOfInterest.ReadOnly]]
    def dataSharingPreference: Optional[
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference.ReadOnly
    ]
    def getInput: ZIO[
      Any,
      Nothing,
      zio.aws.rekognition.model.StreamProcessorInput.ReadOnly
    ] = ZIO.succeed(input)
    def getOutput: ZIO[
      Any,
      Nothing,
      zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly
    ] = ZIO.succeed(output)
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
    def getSettings: ZIO[
      Any,
      Nothing,
      zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly
    ] = ZIO.succeed(settings)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorNotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRegionsOfInterest: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.RegionOfInterest.ReadOnly
    ]] = AwsError.unwrapOptionField("regionsOfInterest", regionsOfInterest)
    def getDataSharingPreference: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference.ReadOnly
    ] =
      AwsError.unwrapOptionField("dataSharingPreference", dataSharingPreference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
  ) extends zio.aws.rekognition.model.CreateStreamProcessorRequest.ReadOnly {
    override val input
        : zio.aws.rekognition.model.StreamProcessorInput.ReadOnly =
      zio.aws.rekognition.model.StreamProcessorInput.wrap(impl.input())
    override val output
        : zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly =
      zio.aws.rekognition.model.StreamProcessorOutput.wrap(impl.output())
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
    override val settings
        : zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly =
      zio.aws.rekognition.model.StreamProcessorSettings.wrap(impl.settings())
    override val roleArn: RoleArn =
      zio.aws.rekognition.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rekognition.model.primitives.TagKey(
              key
            ) -> zio.aws.rekognition.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val notificationChannel: Optional[
      zio.aws.rekognition.model.StreamProcessorNotificationChannel.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationChannel())
      .map(value =>
        zio.aws.rekognition.model.StreamProcessorNotificationChannel.wrap(value)
      )
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.rekognition.model.primitives.KmsKeyId(value))
    override val regionsOfInterest
        : Optional[List[zio.aws.rekognition.model.RegionOfInterest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionsOfInterest())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.RegionOfInterest.wrap(item)
          }.toList
        )
    override val dataSharingPreference: Optional[
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSharingPreference())
      .map(value =>
        zio.aws.rekognition.model.StreamProcessorDataSharingPreference
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
  ): zio.aws.rekognition.model.CreateStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
