package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  TagValue,
  ProjectArn,
  KmsKeyId,
  VersionName,
  ProjectVersionArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyProjectVersionRequest(
    sourceProjectArn: ProjectArn,
    sourceProjectVersionArn: ProjectVersionArn,
    destinationProjectArn: ProjectArn,
    versionName: VersionName,
    outputConfig: zio.aws.rekognition.model.OutputConfig,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest = {
    import CopyProjectVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest
      .builder()
      .sourceProjectArn(ProjectArn.unwrap(sourceProjectArn): java.lang.String)
      .sourceProjectVersionArn(
        ProjectVersionArn.unwrap(sourceProjectVersionArn): java.lang.String
      )
      .destinationProjectArn(
        ProjectArn.unwrap(destinationProjectArn): java.lang.String
      )
      .versionName(VersionName.unwrap(versionName): java.lang.String)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CopyProjectVersionRequest.ReadOnly =
    zio.aws.rekognition.model.CopyProjectVersionRequest.wrap(buildAwsValue())
}
object CopyProjectVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CopyProjectVersionRequest =
      zio.aws.rekognition.model.CopyProjectVersionRequest(
        sourceProjectArn,
        sourceProjectVersionArn,
        destinationProjectArn,
        versionName,
        outputConfig.asEditable,
        tags.map(value => value),
        kmsKeyId.map(value => value)
      )
    def sourceProjectArn: ProjectArn
    def sourceProjectVersionArn: ProjectVersionArn
    def destinationProjectArn: ProjectArn
    def versionName: VersionName
    def outputConfig: zio.aws.rekognition.model.OutputConfig.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def kmsKeyId: Optional[KmsKeyId]
    def getSourceProjectArn: ZIO[Any, Nothing, ProjectArn] =
      ZIO.succeed(sourceProjectArn)
    def getSourceProjectVersionArn: ZIO[Any, Nothing, ProjectVersionArn] =
      ZIO.succeed(sourceProjectVersionArn)
    def getDestinationProjectArn: ZIO[Any, Nothing, ProjectArn] =
      ZIO.succeed(destinationProjectArn)
    def getVersionName: ZIO[Any, Nothing, VersionName] =
      ZIO.succeed(versionName)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.rekognition.model.OutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest
  ) extends zio.aws.rekognition.model.CopyProjectVersionRequest.ReadOnly {
    override val sourceProjectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.sourceProjectArn())
    override val sourceProjectVersionArn: ProjectVersionArn =
      zio.aws.rekognition.model.primitives
        .ProjectVersionArn(impl.sourceProjectVersionArn())
    override val destinationProjectArn: ProjectArn =
      zio.aws.rekognition.model.primitives
        .ProjectArn(impl.destinationProjectArn())
    override val versionName: VersionName =
      zio.aws.rekognition.model.primitives.VersionName(impl.versionName())
    override val outputConfig: zio.aws.rekognition.model.OutputConfig.ReadOnly =
      zio.aws.rekognition.model.OutputConfig.wrap(impl.outputConfig())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rekognition.model.primitives.TagKey(
              key
            ) -> zio.aws.rekognition.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.rekognition.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest
  ): zio.aws.rekognition.model.CopyProjectVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
