package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, ConnectedHomeLabel}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectedHomeSettings(
    labels: Iterable[ConnectedHomeLabel],
    minConfidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettings = {
    import ConnectedHomeSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettings
      .builder()
      .labels(labels.map { item =>
        ConnectedHomeLabel.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ConnectedHomeSettings.ReadOnly =
    zio.aws.rekognition.model.ConnectedHomeSettings.wrap(buildAwsValue())
}
object ConnectedHomeSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ConnectedHomeSettings =
      zio.aws.rekognition.model
        .ConnectedHomeSettings(labels, minConfidence.map(value => value))
    def labels: List[ConnectedHomeLabel]
    def minConfidence: Optional[Percent]
    def getLabels: ZIO[Any, Nothing, List[ConnectedHomeLabel]] =
      ZIO.succeed(labels)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettings
  ) extends zio.aws.rekognition.model.ConnectedHomeSettings.ReadOnly {
    override val labels: List[ConnectedHomeLabel] = impl
      .labels()
      .asScala
      .map { item =>
        zio.aws.rekognition.model.primitives.ConnectedHomeLabel(item)
      }
      .toList
    override val minConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettings
  ): zio.aws.rekognition.model.ConnectedHomeSettings.ReadOnly = new Wrapper(
    impl
  )
}
