package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessorSettingsForUpdate(
    connectedHomeForUpdate: Optional[
      zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorSettingsForUpdate = {
    import StreamProcessorSettingsForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessorSettingsForUpdate
      .builder()
      .optionallyWith(
        connectedHomeForUpdate.map(value => value.buildAwsValue())
      )(_.connectedHomeForUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.ReadOnly =
    zio.aws.rekognition.model.StreamProcessorSettingsForUpdate
      .wrap(buildAwsValue())
}
object StreamProcessorSettingsForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessorSettingsForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessorSettingsForUpdate =
      zio.aws.rekognition.model.StreamProcessorSettingsForUpdate(
        connectedHomeForUpdate.map(value => value.asEditable)
      )
    def connectedHomeForUpdate: Optional[
      zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.ReadOnly
    ]
    def getConnectedHomeForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectedHomeForUpdate",
      connectedHomeForUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorSettingsForUpdate
  ) extends zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.ReadOnly {
    override val connectedHomeForUpdate: Optional[
      zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectedHomeForUpdate())
      .map(value =>
        zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorSettingsForUpdate
  ): zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.ReadOnly =
    new Wrapper(impl)
}
