package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StartStreamProcessorSessionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartStreamProcessorResponse(
    sessionId: Optional[StartStreamProcessorSessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse = {
    import StartStreamProcessorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse
      .builder()
      .optionallyWith(
        sessionId.map(value =>
          StartStreamProcessorSessionId.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly =
    zio.aws.rekognition.model.StartStreamProcessorResponse.wrap(buildAwsValue())
}
object StartStreamProcessorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartStreamProcessorResponse =
      zio.aws.rekognition.model
        .StartStreamProcessorResponse(sessionId.map(value => value))
    def sessionId: Optional[StartStreamProcessorSessionId]
    def getSessionId: ZIO[Any, AwsError, StartStreamProcessorSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse
  ) extends zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly {
    override val sessionId: Optional[StartStreamProcessorSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionId())
        .map(value =>
          zio.aws.rekognition.model.primitives
            .StartStreamProcessorSessionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse
  ): zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly =
    new Wrapper(impl)
}
