package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  Percent,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartLabelDetectionRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    minConfidence: Optional[Percent] = Optional.Absent,
    notificationChannel: Optional[
      zio.aws.rekognition.model.NotificationChannel
    ] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent,
    features: Optional[
      Iterable[zio.aws.rekognition.model.LabelDetectionFeatureName]
    ] = Optional.Absent,
    settings: Optional[zio.aws.rekognition.model.LabelDetectionSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest = {
    import StartLabelDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(
        features.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featuresWithStrings)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartLabelDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.StartLabelDetectionRequest.wrap(buildAwsValue())
}
object StartLabelDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartLabelDetectionRequest =
      zio.aws.rekognition.model.StartLabelDetectionRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        minConfidence.map(value => value),
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value),
        features.map(value => value),
        settings.map(value => value.asEditable)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def minConfidence: Optional[Percent]
    def notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Optional[JobTag]
    def features
        : Optional[List[zio.aws.rekognition.model.LabelDetectionFeatureName]]
    def settings
        : Optional[zio.aws.rekognition.model.LabelDetectionSettings.ReadOnly]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getFeatures: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.LabelDetectionFeatureName
    ]] = AwsError.unwrapOptionField("features", features)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.LabelDetectionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
  ) extends zio.aws.rekognition.model.StartLabelDetectionRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
    override val minConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationChannel())
        .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
    override val features
        : Optional[List[zio.aws.rekognition.model.LabelDetectionFeatureName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.features())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.LabelDetectionFeatureName.wrap(item)
          }.toList
        )
    override val settings
        : Optional[zio.aws.rekognition.model.LabelDetectionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          zio.aws.rekognition.model.LabelDetectionSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
  ): zio.aws.rekognition.model.StartLabelDetectionRequest.ReadOnly =
    new Wrapper(impl)
}
