package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{JobTag, ClientRequestToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartFaceDetectionRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    notificationChannel: Optional[
      zio.aws.rekognition.model.NotificationChannel
    ] = Optional.Absent,
    faceAttributes: Optional[zio.aws.rekognition.model.FaceAttributes] =
      Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest = {
    import StartFaceDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(faceAttributes.map(value => value.unwrap))(
        _.faceAttributes
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartFaceDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.StartFaceDetectionRequest.wrap(buildAwsValue())
}
object StartFaceDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartFaceDetectionRequest =
      zio.aws.rekognition.model.StartFaceDetectionRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        notificationChannel.map(value => value.asEditable),
        faceAttributes.map(value => value),
        jobTag.map(value => value)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def faceAttributes: Optional[zio.aws.rekognition.model.FaceAttributes]
    def jobTag: Optional[JobTag]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getFaceAttributes
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceAttributes] =
      AwsError.unwrapOptionField("faceAttributes", faceAttributes)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest
  ) extends zio.aws.rekognition.model.StartFaceDetectionRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
    override val notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationChannel())
        .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val faceAttributes
        : Optional[zio.aws.rekognition.model.FaceAttributes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceAttributes())
        .map(value => zio.aws.rekognition.model.FaceAttributes.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest
  ): zio.aws.rekognition.model.StartFaceDetectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
