package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentSummarizationAttributes(
    minConfidence: Percent,
    requiredEquipmentTypes: Iterable[
      zio.aws.rekognition.model.ProtectiveEquipmentType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes = {
    import ProtectiveEquipmentSummarizationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes
      .builder()
      .minConfidence(Percent.unwrap(minConfidence): java.lang.Float)
      .requiredEquipmentTypesWithStrings(requiredEquipmentTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes
      .wrap(buildAwsValue())
}
object ProtectiveEquipmentSummarizationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes =
      zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes(
        minConfidence,
        requiredEquipmentTypes
      )
    def minConfidence: Percent
    def requiredEquipmentTypes
        : List[zio.aws.rekognition.model.ProtectiveEquipmentType]
    def getMinConfidence: ZIO[Any, Nothing, Percent] =
      ZIO.succeed(minConfidence)
    def getRequiredEquipmentTypes: ZIO[Any, Nothing, List[
      zio.aws.rekognition.model.ProtectiveEquipmentType
    ]] = ZIO.succeed(requiredEquipmentTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes.ReadOnly {
    override val minConfidence: Percent =
      zio.aws.rekognition.model.primitives.Percent(impl.minConfidence())
    override val requiredEquipmentTypes
        : List[zio.aws.rekognition.model.ProtectiveEquipmentType] = impl
      .requiredEquipmentTypes()
      .asScala
      .map { item =>
        zio.aws.rekognition.model.ProtectiveEquipmentType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes
  ): zio.aws.rekognition.model.ProtectiveEquipmentSummarizationAttributes.ReadOnly =
    new Wrapper(impl)
}
