package zio.aws.rekognition.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  DateTime,
  ProjectArn,
  ProjectPolicyDocument,
  ProjectPolicyName,
  ProjectPolicyRevisionId
}
import scala.jdk.CollectionConverters._
final case class ProjectPolicy(
    projectArn: Optional[ProjectArn] = Optional.Absent,
    policyName: Optional[ProjectPolicyName] = Optional.Absent,
    policyRevisionId: Optional[ProjectPolicyRevisionId] = Optional.Absent,
    policyDocument: Optional[ProjectPolicyDocument] = Optional.Absent,
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    lastUpdatedTimestamp: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProjectPolicy = {
    import ProjectPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProjectPolicy
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        policyName.map(value =>
          ProjectPolicyName.unwrap(value): java.lang.String
        )
      )(_.policyName)
      .optionallyWith(
        policyRevisionId.map(value =>
          ProjectPolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .optionallyWith(
        policyDocument.map(value =>
          ProjectPolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ProjectPolicy.ReadOnly =
    zio.aws.rekognition.model.ProjectPolicy.wrap(buildAwsValue())
}
object ProjectPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProjectPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProjectPolicy =
      zio.aws.rekognition.model.ProjectPolicy(
        projectArn.map(value => value),
        policyName.map(value => value),
        policyRevisionId.map(value => value),
        policyDocument.map(value => value),
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def projectArn: Optional[ProjectArn]
    def policyName: Optional[ProjectPolicyName]
    def policyRevisionId: Optional[ProjectPolicyRevisionId]
    def policyDocument: Optional[ProjectPolicyDocument]
    def creationTimestamp: Optional[DateTime]
    def lastUpdatedTimestamp: Optional[DateTime]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getPolicyName: ZIO[Any, AwsError, ProjectPolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyRevisionId: ZIO[Any, AwsError, ProjectPolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
    def getPolicyDocument: ZIO[Any, AwsError, ProjectPolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectPolicy
  ) extends zio.aws.rekognition.model.ProjectPolicy.ReadOnly {
    override val projectArn: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.projectArn())
      .map(value => zio.aws.rekognition.model.primitives.ProjectArn(value))
    override val policyName: Optional[ProjectPolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value =>
        zio.aws.rekognition.model.primitives.ProjectPolicyName(value)
      )
    override val policyRevisionId: Optional[ProjectPolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectPolicyRevisionId(value)
        )
    override val policyDocument: Optional[ProjectPolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectPolicyDocument(value)
        )
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val lastUpdatedTimestamp: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectPolicy
  ): zio.aws.rekognition.model.ProjectPolicy.ReadOnly = new Wrapper(impl)
}
