package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ExtendedPaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProjectPoliciesResponse(
    projectPolicies: Optional[
      Iterable[zio.aws.rekognition.model.ProjectPolicy]
    ] = Optional.Absent,
    nextToken: Optional[ExtendedPaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse = {
    import ListProjectPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse
      .builder()
      .optionallyWith(
        projectPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectPolicies)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly =
    zio.aws.rekognition.model.ListProjectPoliciesResponse.wrap(buildAwsValue())
}
object ListProjectPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListProjectPoliciesResponse =
      zio.aws.rekognition.model.ListProjectPoliciesResponse(
        projectPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def projectPolicies
        : Optional[List[zio.aws.rekognition.model.ProjectPolicy.ReadOnly]]
    def nextToken: Optional[ExtendedPaginationToken]
    def getProjectPolicies: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ProjectPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("projectPolicies", projectPolicies)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse
  ) extends zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly {
    override val projectPolicies
        : Optional[List[zio.aws.rekognition.model.ProjectPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.ProjectPolicy.wrap(item)
          }.toList
        )
    override val nextToken: Optional[ExtendedPaginationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse
  ): zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
